/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import org.deeplearning4j.clustering.algorithm.Distance;
import org.deeplearning4j.clustering.cluster.ClusterUtils;
import org.deeplearning4j.clustering.cluster.Point;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMin;
import org.nd4j.linalg.factory.Nd4j;

public class CentersHolder {
    private INDArray centers;
    private long index = 0L;
    protected transient ReduceOp op;
    protected IMin imin;
    protected transient INDArray distances;
    protected transient INDArray argMin;
    private long rows;
    private long cols;

    public CentersHolder(long rows, long cols) {
        this.rows = rows;
        this.cols = cols;
    }

    public INDArray getCenters() {
        return this.centers;
    }

    public synchronized void addCenter(INDArray pointView) {
        if (this.centers == null) {
            this.centers = Nd4j.create((DataType)pointView.dataType(), (long[])new long[]{this.rows, this.cols});
        }
        this.centers.putRow(this.index++, pointView);
    }

    public synchronized Pair<Double, Long> getCenterByMinDistance(Point point, Distance distanceFunction) {
        if (this.distances == null) {
            this.distances = Nd4j.create((DataType)this.centers.dataType(), (long[])new long[]{this.centers.rows()});
        }
        if (this.argMin == null) {
            this.argMin = Nd4j.createUninitialized((DataType)DataType.LONG, (long[])new long[0]);
        }
        if (this.op == null) {
            this.op = ClusterUtils.createDistanceFunctionOp(distanceFunction, this.centers, point.getArray(), 1);
            this.imin = new IMin(this.distances, this.argMin, new int[0]);
            this.op.setZ(this.distances);
        }
        this.op.setY(point.getArray());
        Nd4j.getExecutioner().exec(this.op);
        Nd4j.getExecutioner().exec((IndexAccumulation)this.imin);
        Pair result = new Pair();
        result.setFirst((Object)this.distances.getDouble(this.argMin.getLong(0L)));
        result.setSecond((Object)this.argMin.getLong(0L));
        return result;
    }

    public synchronized INDArray getMinDistances(Point point, Distance distanceFunction) {
        if (this.distances == null) {
            this.distances = Nd4j.create((DataType)this.centers.dataType(), (long[])new long[]{this.centers.rows()});
        }
        if (this.argMin == null) {
            this.argMin = Nd4j.createUninitialized((DataType)DataType.LONG, (long[])new long[0]);
        }
        if (this.op == null) {
            this.op = ClusterUtils.createDistanceFunctionOp(distanceFunction, this.centers, point.getArray(), 1);
            this.imin = new IMin(this.distances, this.argMin, new int[0]);
            this.op.setZ(this.distances);
        }
        this.op.setY(point.getArray());
        Nd4j.getExecutioner().exec(this.op);
        Nd4j.getExecutioner().exec((IndexAccumulation)this.imin);
        System.out.println(this.distances);
        return this.distances;
    }
}

