/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.deeplearning4j.clustering.algorithm.Distance;
import org.deeplearning4j.clustering.cluster.ClusterUtils;
import org.deeplearning4j.clustering.cluster.Point;
import org.nd4j.linalg.factory.Nd4j;

public class Cluster
implements Serializable {
    private String id = UUID.randomUUID().toString();
    private String label;
    private Point center;
    private List<Point> points = Collections.synchronizedList(new ArrayList());
    private boolean inverse = false;
    private Distance distanceFunction;

    public Cluster() {
    }

    public Cluster(Point center, Distance distanceFunction) {
        this(center, false, distanceFunction);
    }

    public Cluster(Point center, boolean inverse, Distance distanceFunction) {
        this.distanceFunction = distanceFunction;
        this.inverse = inverse;
        this.setCenter(center);
    }

    public double getDistanceToCenter(Point point) {
        return Nd4j.getExecutioner().execAndReturn(ClusterUtils.createDistanceFunctionOp(this.distanceFunction, this.center.getArray(), point.getArray())).getFinalResult().doubleValue();
    }

    public void addPoint(Point point) {
        this.addPoint(point, true);
    }

    public void addPoint(Point point, boolean moveClusterCenter) {
        if (moveClusterCenter) {
            if (this.isInverse()) {
                this.center.getArray().muli((Number)this.points.size()).subi(point.getArray()).divi((Number)(this.points.size() + 1));
            } else {
                this.center.getArray().muli((Number)this.points.size()).addi(point.getArray()).divi((Number)(this.points.size() + 1));
            }
        }
        this.getPoints().add(point);
    }

    public void removePoints() {
        if (this.getPoints() != null) {
            this.getPoints().clear();
        }
    }

    public boolean isEmpty() {
        return this.points == null || this.points.isEmpty();
    }

    public Point getPoint(String id) {
        for (Point point : this.points) {
            if (!id.equals(point.getId())) continue;
            return point;
        }
        return null;
    }

    public Point removePoint(String id) {
        Point removePoint = null;
        for (Point point : this.points) {
            if (!id.equals(point.getId())) continue;
            removePoint = point;
        }
        if (removePoint != null) {
            this.points.remove(removePoint);
        }
        return removePoint;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Point getCenter() {
        return this.center;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public Distance getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public void setDistanceFunction(Distance distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Point this$center = this.getCenter();
        Point other$center = other.getCenter();
        if (this$center == null ? other$center != null : !((Object)this$center).equals(other$center)) {
            return false;
        }
        List<Point> this$points = this.getPoints();
        List<Point> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        if (this.isInverse() != other.isInverse()) {
            return false;
        }
        Distance this$distanceFunction = this.getDistanceFunction();
        Distance other$distanceFunction = other.getDistanceFunction();
        return !(this$distanceFunction == null ? other$distanceFunction != null : !((Object)((Object)this$distanceFunction)).equals((Object)other$distanceFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Point $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : ((Object)$center).hashCode());
        List<Point> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        result = result * 59 + (this.isInverse() ? 79 : 97);
        Distance $distanceFunction = this.getDistanceFunction();
        result = result * 59 + ($distanceFunction == null ? 43 : ((Object)((Object)$distanceFunction)).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(id=" + this.getId() + ", label=" + this.getLabel() + ", center=" + this.getCenter() + ", points=" + this.getPoints() + ", inverse=" + this.isInverse() + ", distanceFunction=" + (Object)((Object)this.getDistanceFunction()) + ")";
    }
}

