/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.clustering.algorithm.Distance;
import org.deeplearning4j.clustering.cluster.CentersHolder;
import org.deeplearning4j.clustering.cluster.Cluster;
import org.deeplearning4j.clustering.cluster.ClusterUtils;
import org.deeplearning4j.clustering.cluster.Point;
import org.deeplearning4j.clustering.cluster.PointClassification;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.factory.Nd4j;

public class ClusterSet
implements Serializable {
    private Distance distanceFunction;
    private List<Cluster> clusters;
    private CentersHolder centersHolder;
    private Map<String, String> pointDistribution;
    private boolean inverse;

    public ClusterSet(boolean inverse) {
        this(null, inverse, null);
    }

    public ClusterSet(Distance distanceFunction, boolean inverse, long[] shape) {
        this.distanceFunction = distanceFunction;
        this.inverse = inverse;
        this.clusters = Collections.synchronizedList(new ArrayList());
        this.pointDistribution = Collections.synchronizedMap(new HashMap());
        if (shape != null) {
            this.centersHolder = new CentersHolder(shape[0], shape[1]);
        }
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public Cluster addNewClusterWithCenter(Point center) {
        Cluster newCluster = new Cluster(center, this.distanceFunction);
        this.getClusters().add(newCluster);
        this.setPointLocation(center, newCluster);
        this.centersHolder.addCenter(center.getArray());
        return newCluster;
    }

    public PointClassification classifyPoint(Point point) {
        return this.classifyPoint(point, true);
    }

    public void classifyPoints(List<Point> points) {
        this.classifyPoints(points, true);
    }

    public void classifyPoints(List<Point> points, boolean moveClusterCenter) {
        for (Point point : points) {
            this.classifyPoint(point, moveClusterCenter);
        }
    }

    public PointClassification classifyPoint(Point point, boolean moveClusterCenter) {
        Pair<Cluster, Double> nearestCluster = this.nearestCluster(point);
        Cluster newCluster = (Cluster)nearestCluster.getKey();
        boolean locationChange = this.isPointLocationChange(point, newCluster);
        this.addPointToCluster(point, newCluster, moveClusterCenter);
        return new PointClassification((Cluster)nearestCluster.getKey(), (Double)nearestCluster.getValue(), locationChange);
    }

    private boolean isPointLocationChange(Point point, Cluster newCluster) {
        if (!this.getPointDistribution().containsKey(point.getId())) {
            return true;
        }
        return !this.getPointDistribution().get(point.getId()).equals(newCluster.getId());
    }

    private void addPointToCluster(Point point, Cluster cluster, boolean moveClusterCenter) {
        cluster.addPoint(point, moveClusterCenter);
        this.setPointLocation(point, cluster);
    }

    private void setPointLocation(Point point, Cluster cluster) {
        this.pointDistribution.put(point.getId(), cluster.getId());
    }

    public Pair<Cluster, Double> nearestCluster(Point point) {
        Pair<Double, Long> nearestCenterData = this.centersHolder.getCenterByMinDistance(point, this.distanceFunction);
        Cluster nearestCluster = this.getClusters().get(((Long)nearestCenterData.getSecond()).intValue());
        double minDistance = (Double)nearestCenterData.getFirst();
        return Pair.of((Object)nearestCluster, (Object)minDistance);
    }

    public double getDistance(Point m1, Point m2) {
        return Nd4j.getExecutioner().execAndReturn(ClusterUtils.createDistanceFunctionOp(this.distanceFunction, m1.getArray(), m2.getArray())).getFinalResult().doubleValue();
    }

    public String getClusterCenterId(String clusterId) {
        Point clusterCenter = this.getClusterCenter(clusterId);
        return clusterCenter == null ? null : clusterCenter.getId();
    }

    public Point getClusterCenter(String clusterId) {
        Cluster cluster = this.getCluster(clusterId);
        return cluster == null ? null : cluster.getCenter();
    }

    public Cluster getCluster(String id) {
        int j = this.clusters.size();
        for (int i = 0; i < j; ++i) {
            if (!id.equals(this.clusters.get(i).getId())) continue;
            return this.clusters.get(i);
        }
        return null;
    }

    public int getClusterCount() {
        return this.getClusters() == null ? 0 : this.getClusters().size();
    }

    public void removePoints() {
        for (Cluster cluster : this.getClusters()) {
            cluster.removePoints();
        }
    }

    public List<Cluster> getMostPopulatedClusters(int count) {
        ArrayList<Cluster> mostPopulated = new ArrayList<Cluster>(this.clusters);
        Collections.sort(mostPopulated, new Comparator<Cluster>(){

            @Override
            public int compare(Cluster o1, Cluster o2) {
                return Integer.compare(o2.getPoints().size(), o1.getPoints().size());
            }
        });
        return mostPopulated.subList(0, count);
    }

    public List<Cluster> removeEmptyClusters() {
        ArrayList<Cluster> emptyClusters = new ArrayList<Cluster>();
        for (Cluster cluster : this.clusters) {
            if (!cluster.isEmpty()) continue;
            emptyClusters.add(cluster);
        }
        this.clusters.removeAll(emptyClusters);
        return emptyClusters;
    }

    public Distance getDistanceFunction() {
        return this.distanceFunction;
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public CentersHolder getCentersHolder() {
        return this.centersHolder;
    }

    public Map<String, String> getPointDistribution() {
        return this.pointDistribution;
    }

    public void setDistanceFunction(Distance distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public void setClusters(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    public void setCentersHolder(CentersHolder centersHolder) {
        this.centersHolder = centersHolder;
    }

    public void setPointDistribution(Map<String, String> pointDistribution) {
        this.pointDistribution = pointDistribution;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterSet)) {
            return false;
        }
        ClusterSet other = (ClusterSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Distance this$distanceFunction = this.getDistanceFunction();
        Distance other$distanceFunction = other.getDistanceFunction();
        if (this$distanceFunction == null ? other$distanceFunction != null : !((Object)((Object)this$distanceFunction)).equals((Object)other$distanceFunction)) {
            return false;
        }
        List<Cluster> this$clusters = this.getClusters();
        List<Cluster> other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        CentersHolder this$centersHolder = this.getCentersHolder();
        CentersHolder other$centersHolder = other.getCentersHolder();
        if (this$centersHolder == null ? other$centersHolder != null : !this$centersHolder.equals(other$centersHolder)) {
            return false;
        }
        Map<String, String> this$pointDistribution = this.getPointDistribution();
        Map<String, String> other$pointDistribution = other.getPointDistribution();
        if (this$pointDistribution == null ? other$pointDistribution != null : !((Object)this$pointDistribution).equals(other$pointDistribution)) {
            return false;
        }
        return this.isInverse() == other.isInverse();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Distance $distanceFunction = this.getDistanceFunction();
        result = result * 59 + ($distanceFunction == null ? 43 : ((Object)((Object)$distanceFunction)).hashCode());
        List<Cluster> $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        CentersHolder $centersHolder = this.getCentersHolder();
        result = result * 59 + ($centersHolder == null ? 43 : $centersHolder.hashCode());
        Map<String, String> $pointDistribution = this.getPointDistribution();
        result = result * 59 + ($pointDistribution == null ? 43 : ((Object)$pointDistribution).hashCode());
        result = result * 59 + (this.isInverse() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClusterSet(distanceFunction=" + (Object)((Object)this.getDistanceFunction()) + ", clusters=" + this.getClusters() + ", centersHolder=" + this.getCentersHolder() + ", pointDistribution=" + this.getPointDistribution() + ", inverse=" + this.isInverse() + ")";
    }
}

