/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class Point
implements Serializable {
    private static final long serialVersionUID = -6658028541426027226L;
    private String id = UUID.randomUUID().toString();
    private String label;
    private INDArray array;

    public Point(INDArray array) {
        this.array = array;
    }

    public Point(String id, INDArray array) {
        this.id = id;
        this.array = array;
    }

    public Point(String id, String label, double[] data) {
        this(id, label, Nd4j.create((double[])data));
    }

    public Point(String id, String label, INDArray array) {
        this.id = id;
        this.label = label;
        this.array = array;
    }

    public static List<Point> toPoints(INDArray matrix) {
        ArrayList<Point> arr = new ArrayList<Point>(matrix.rows());
        for (int i = 0; i < matrix.rows(); ++i) {
            arr.add(new Point(matrix.getRow((long)i)));
        }
        return arr;
    }

    public static List<Point> toPoints(List<INDArray> vectors) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (INDArray vector : vectors) {
            points.add(new Point(vector));
        }
        return points;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public INDArray getArray() {
        return this.array;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setArray(INDArray array) {
        this.array = array;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        INDArray this$array = this.getArray();
        INDArray other$array = other.getArray();
        return !(this$array == null ? other$array != null : !this$array.equals(other$array));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        INDArray $array = this.getArray();
        result = result * 59 + ($array == null ? 43 : $array.hashCode());
        return result;
    }

    public String toString() {
        return "Point(id=" + this.getId() + ", label=" + this.getLabel() + ", array=" + this.getArray() + ")";
    }

    protected Point() {
    }
}

