/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.condition;

import java.io.Serializable;
import org.deeplearning4j.clustering.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.iteration.IterationHistory;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.LessThan;

public class ConvergenceCondition
implements ClusteringAlgorithmCondition,
Serializable {
    private Condition convergenceCondition;
    private double pointsDistributionChangeRate;

    public static ConvergenceCondition distributionVariationRateLessThan(double pointsDistributionChangeRate) {
        LessThan condition = new LessThan((Number)pointsDistributionChangeRate);
        return new ConvergenceCondition((Condition)condition, pointsDistributionChangeRate);
    }

    @Override
    public boolean isSatisfied(IterationHistory iterationHistory) {
        int iterationCount = iterationHistory.getIterationCount();
        if (iterationCount <= 1) {
            return false;
        }
        double variation = iterationHistory.getMostRecentClusterSetInfo().getPointLocationChange().get();
        return this.convergenceCondition.apply((Number)(variation /= (double)iterationHistory.getMostRecentClusterSetInfo().getPointsCount()));
    }

    protected ConvergenceCondition() {
    }

    protected ConvergenceCondition(Condition convergenceCondition, double pointsDistributionChangeRate) {
        this.convergenceCondition = convergenceCondition;
        this.pointsDistributionChangeRate = pointsDistributionChangeRate;
    }
}

