/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterInfo
implements Serializable {
    private double averagePointDistanceFromCenter;
    private double maxPointDistanceFromCenter;
    private double pointDistanceFromCenterVariance;
    private double totalPointDistanceFromCenter;
    private boolean inverse;
    private Map<String, Double> pointDistancesFromCenter = new ConcurrentHashMap<String, Double>();

    public ClusterInfo(boolean inverse) {
        this(false, inverse);
    }

    public ClusterInfo(boolean threadSafe, boolean inverse) {
        this.inverse = inverse;
        if (threadSafe) {
            this.pointDistancesFromCenter = Collections.synchronizedMap(this.pointDistancesFromCenter);
        }
    }

    public Set<Map.Entry<String, Double>> getSortedPointDistancesFromCenter() {
        TreeSet<Map.Entry<String, Double>> sortedEntries = new TreeSet<Map.Entry<String, Double>>(new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> e1, Map.Entry<String, Double> e2) {
                int res = e1.getValue().compareTo(e2.getValue());
                return res != 0 ? res : 1;
            }
        });
        sortedEntries.addAll(this.pointDistancesFromCenter.entrySet());
        return sortedEntries;
    }

    public Set<Map.Entry<String, Double>> getReverseSortedPointDistancesFromCenter() {
        TreeSet<Map.Entry<String, Double>> sortedEntries = new TreeSet<Map.Entry<String, Double>>(new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> e1, Map.Entry<String, Double> e2) {
                int res = e1.getValue().compareTo(e2.getValue());
                return -(res != 0 ? res : 1);
            }
        });
        sortedEntries.addAll(this.pointDistancesFromCenter.entrySet());
        return sortedEntries;
    }

    public List<String> getPointsFartherFromCenterThan(double maxDistance) {
        Set<Map.Entry<String, Double>> sorted = this.getReverseSortedPointDistancesFromCenter();
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<String, Double> entry : sorted) {
            if (this.inverse && entry.getValue() < -maxDistance ? entry.getValue() < -maxDistance : entry.getValue() > maxDistance) break;
            ids.add(entry.getKey());
        }
        return ids;
    }

    public double getAveragePointDistanceFromCenter() {
        return this.averagePointDistanceFromCenter;
    }

    public double getMaxPointDistanceFromCenter() {
        return this.maxPointDistanceFromCenter;
    }

    public double getPointDistanceFromCenterVariance() {
        return this.pointDistanceFromCenterVariance;
    }

    public double getTotalPointDistanceFromCenter() {
        return this.totalPointDistanceFromCenter;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public Map<String, Double> getPointDistancesFromCenter() {
        return this.pointDistancesFromCenter;
    }

    public void setAveragePointDistanceFromCenter(double averagePointDistanceFromCenter) {
        this.averagePointDistanceFromCenter = averagePointDistanceFromCenter;
    }

    public void setMaxPointDistanceFromCenter(double maxPointDistanceFromCenter) {
        this.maxPointDistanceFromCenter = maxPointDistanceFromCenter;
    }

    public void setPointDistanceFromCenterVariance(double pointDistanceFromCenterVariance) {
        this.pointDistanceFromCenterVariance = pointDistanceFromCenterVariance;
    }

    public void setTotalPointDistanceFromCenter(double totalPointDistanceFromCenter) {
        this.totalPointDistanceFromCenter = totalPointDistanceFromCenter;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public void setPointDistancesFromCenter(Map<String, Double> pointDistancesFromCenter) {
        this.pointDistancesFromCenter = pointDistancesFromCenter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAveragePointDistanceFromCenter(), other.getAveragePointDistanceFromCenter()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxPointDistanceFromCenter(), other.getMaxPointDistanceFromCenter()) != 0) {
            return false;
        }
        if (Double.compare(this.getPointDistanceFromCenterVariance(), other.getPointDistanceFromCenterVariance()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalPointDistanceFromCenter(), other.getTotalPointDistanceFromCenter()) != 0) {
            return false;
        }
        if (this.isInverse() != other.isInverse()) {
            return false;
        }
        Map<String, Double> this$pointDistancesFromCenter = this.getPointDistancesFromCenter();
        Map<String, Double> other$pointDistancesFromCenter = other.getPointDistancesFromCenter();
        return !(this$pointDistancesFromCenter == null ? other$pointDistancesFromCenter != null : !((Object)this$pointDistancesFromCenter).equals(other$pointDistancesFromCenter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $averagePointDistanceFromCenter = Double.doubleToLongBits(this.getAveragePointDistanceFromCenter());
        result = result * 59 + (int)($averagePointDistanceFromCenter >>> 32 ^ $averagePointDistanceFromCenter);
        long $maxPointDistanceFromCenter = Double.doubleToLongBits(this.getMaxPointDistanceFromCenter());
        result = result * 59 + (int)($maxPointDistanceFromCenter >>> 32 ^ $maxPointDistanceFromCenter);
        long $pointDistanceFromCenterVariance = Double.doubleToLongBits(this.getPointDistanceFromCenterVariance());
        result = result * 59 + (int)($pointDistanceFromCenterVariance >>> 32 ^ $pointDistanceFromCenterVariance);
        long $totalPointDistanceFromCenter = Double.doubleToLongBits(this.getTotalPointDistanceFromCenter());
        result = result * 59 + (int)($totalPointDistanceFromCenter >>> 32 ^ $totalPointDistanceFromCenter);
        result = result * 59 + (this.isInverse() ? 79 : 97);
        Map<String, Double> $pointDistancesFromCenter = this.getPointDistancesFromCenter();
        result = result * 59 + ($pointDistancesFromCenter == null ? 43 : ((Object)$pointDistancesFromCenter).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterInfo(averagePointDistanceFromCenter=" + this.getAveragePointDistanceFromCenter() + ", maxPointDistanceFromCenter=" + this.getMaxPointDistanceFromCenter() + ", pointDistanceFromCenterVariance=" + this.getPointDistanceFromCenterVariance() + ", totalPointDistanceFromCenter=" + this.getTotalPointDistanceFromCenter() + ", inverse=" + this.isInverse() + ", pointDistancesFromCenter=" + this.getPointDistancesFromCenter() + ")";
    }
}

