/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.kdtree;

import java.io.Serializable;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.custom.KnnMinDistance;
import org.nd4j.linalg.factory.Nd4j;

public class HyperRect
implements Serializable {
    private float[] lowerEnds;
    private float[] higherEnds;
    private INDArray lowerEndsIND;
    private INDArray higherEndsIND;

    public HyperRect(float[] lowerEndsIn, float[] higherEndsIn) {
        this.lowerEnds = new float[lowerEndsIn.length];
        this.higherEnds = new float[lowerEndsIn.length];
        System.arraycopy(lowerEndsIn, 0, this.lowerEnds, 0, lowerEndsIn.length);
        System.arraycopy(higherEndsIn, 0, this.higherEnds, 0, higherEndsIn.length);
        this.lowerEndsIND = Nd4j.createFromArray((float[])this.lowerEnds);
        this.higherEndsIND = Nd4j.createFromArray((float[])this.higherEnds);
    }

    public HyperRect(float[] point) {
        this(point, point);
    }

    public HyperRect(Pair<float[], float[]> ends) {
        this((float[])ends.getFirst(), (float[])ends.getSecond());
    }

    public void enlargeTo(INDArray point) {
        float[] pointAsArray = point.toFloatVector();
        for (int i = 0; i < this.lowerEnds.length; ++i) {
            float p = pointAsArray[i];
            if (this.lowerEnds[i] > p) {
                this.lowerEnds[i] = p;
                continue;
            }
            if (!(this.higherEnds[i] < p)) continue;
            this.higherEnds[i] = p;
        }
    }

    public static Pair<float[], float[]> point(INDArray vector) {
        Pair ret = new Pair();
        float[] curr = new float[(int)vector.length()];
        int i = 0;
        while ((long)i < vector.length()) {
            curr[i] = vector.getFloat((long)i);
            ++i;
        }
        ret.setFirst((Object)curr);
        ret.setSecond((Object)curr);
        return ret;
    }

    public double minDistance(INDArray hPoint, INDArray output) {
        Nd4j.exec((CustomOp)new KnnMinDistance(hPoint, this.lowerEndsIND, this.higherEndsIND, output));
        return output.getFloat(0L);
    }

    public HyperRect getUpper(INDArray hPoint, int desc) {
        float higher = this.higherEnds[desc];
        float d = hPoint.getFloat((long)desc);
        if (higher < d) {
            return null;
        }
        HyperRect ret = new HyperRect(this.lowerEnds, this.higherEnds);
        if (ret.lowerEnds[desc] < d) {
            ret.lowerEnds[desc] = d;
        }
        return ret;
    }

    public HyperRect getLower(INDArray hPoint, int desc) {
        float lower = this.lowerEnds[desc];
        float d = hPoint.getFloat((long)desc);
        if (lower > d) {
            return null;
        }
        HyperRect ret = new HyperRect(this.lowerEnds, this.higherEnds);
        if (ret.higherEnds[desc] > d) {
            ret.higherEnds[desc] = d;
        }
        return ret;
    }

    public String toString() {
        String retVal = "";
        retVal = retVal + "[";
        for (int i = 0; i < this.lowerEnds.length; ++i) {
            retVal = retVal + "(" + this.lowerEnds[i] + " - " + this.higherEnds[i] + ") ";
        }
        retVal = retVal + "]";
        return retVal;
    }
}

