/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.kmeans;

import org.deeplearning4j.clustering.algorithm.BaseClusteringAlgorithm;
import org.deeplearning4j.clustering.algorithm.Distance;
import org.deeplearning4j.clustering.strategy.BaseClusteringStrategy;
import org.deeplearning4j.clustering.strategy.ClusteringStrategy;
import org.deeplearning4j.clustering.strategy.FixedClusterCountStrategy;

public class KMeansClustering
extends BaseClusteringAlgorithm {
    private static final long serialVersionUID = 8476951388145944776L;
    private static final double VARIATION_TOLERANCE = 1.0E-4;

    protected KMeansClustering(ClusteringStrategy clusteringStrategy, boolean useKMeansPlusPlus) {
        super(clusteringStrategy, useKMeansPlusPlus);
    }

    public static KMeansClustering setup(int clusterCount, int maxIterationCount, Distance distanceFunction, boolean inverse, boolean useKMeansPlusPlus) {
        FixedClusterCountStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction, inverse);
        clusteringStrategy.endWhenIterationCountEquals(maxIterationCount);
        return new KMeansClustering(clusteringStrategy, useKMeansPlusPlus);
    }

    public static KMeansClustering setup(int clusterCount, double minDistributionVariationRate, Distance distanceFunction, boolean inverse, boolean allowEmptyClusters, boolean useKMeansPlusPlus) {
        BaseClusteringStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction, inverse).endWhenDistributionVariationRateLessThan(minDistributionVariationRate);
        return new KMeansClustering(clusteringStrategy, useKMeansPlusPlus);
    }

    public static KMeansClustering setup(int clusterCount, int maxIterationCount, Distance distanceFunction, boolean useKMeansPlusPlus) {
        return KMeansClustering.setup(clusterCount, maxIterationCount, distanceFunction, false, useKMeansPlusPlus);
    }

    public static KMeansClustering setup(int clusterCount, double minDistributionVariationRate, Distance distanceFunction, boolean allowEmptyClusters, boolean useKMeansPlusPlus) {
        FixedClusterCountStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction, false);
        clusteringStrategy.endWhenDistributionVariationRateLessThan(minDistributionVariationRate);
        return new KMeansClustering(clusteringStrategy, useKMeansPlusPlus);
    }

    public static KMeansClustering setup(int clusterCount, Distance distanceFunction, boolean allowEmptyClusters, boolean useKMeansPlusPlus) {
        FixedClusterCountStrategy clusteringStrategy = FixedClusterCountStrategy.setup(clusterCount, distanceFunction, false);
        clusteringStrategy.endWhenDistributionVariationRateLessThan(1.0E-4);
        return new KMeansClustering(clusteringStrategy, useKMeansPlusPlus);
    }
}

