/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.randomprojection;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.clustering.randomprojection.RPTree;
import org.deeplearning4j.clustering.randomprojection.RPUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RPForest {
    private int numTrees;
    private List<RPTree> trees;
    private INDArray data;
    private int maxSize = 1000;
    private String similarityFunction;

    public RPForest(int numTrees, int maxSize, String similarityFunction) {
        this.numTrees = numTrees;
        this.maxSize = maxSize;
        this.similarityFunction = similarityFunction;
        this.trees = new ArrayList<RPTree>(numTrees);
    }

    public void fit(INDArray x) {
        this.data = x;
        for (int i = 0; i < this.numTrees; ++i) {
            RPTree tree = new RPTree(this.data.columns(), this.maxSize, this.similarityFunction);
            tree.buildTree(x);
            this.trees.add(tree);
        }
    }

    public INDArray getAllCandidates(INDArray input) {
        return RPUtils.getAllCandidates(input, this.trees, this.similarityFunction);
    }

    public INDArray queryAll(INDArray toQuery, int n) {
        return RPUtils.queryAll(toQuery, this.data, this.trees, n, this.similarityFunction);
    }

    public List<Pair<Double, Integer>> queryWithDistances(INDArray query, int numResults) {
        return RPUtils.queryAllWithDistances(query, this.data, this.trees, numResults, this.similarityFunction);
    }

    public int getNumTrees() {
        return this.numTrees;
    }

    public List<RPTree> getTrees() {
        return this.trees;
    }

    public INDArray getData() {
        return this.data;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getSimilarityFunction() {
        return this.similarityFunction;
    }

    public void setNumTrees(int numTrees) {
        this.numTrees = numTrees;
    }

    public void setTrees(List<RPTree> trees) {
        this.trees = trees;
    }

    public void setData(INDArray data) {
        this.data = data;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setSimilarityFunction(String similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RPForest)) {
            return false;
        }
        RPForest other = (RPForest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumTrees() != other.getNumTrees()) {
            return false;
        }
        List<RPTree> this$trees = this.getTrees();
        List<RPTree> other$trees = other.getTrees();
        if (this$trees == null ? other$trees != null : !((Object)this$trees).equals(other$trees)) {
            return false;
        }
        INDArray this$data = this.getData();
        INDArray other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        String this$similarityFunction = this.getSimilarityFunction();
        String other$similarityFunction = other.getSimilarityFunction();
        return !(this$similarityFunction == null ? other$similarityFunction != null : !this$similarityFunction.equals(other$similarityFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RPForest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumTrees();
        List<RPTree> $trees = this.getTrees();
        result = result * 59 + ($trees == null ? 43 : ((Object)$trees).hashCode());
        INDArray $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getMaxSize();
        String $similarityFunction = this.getSimilarityFunction();
        result = result * 59 + ($similarityFunction == null ? 43 : $similarityFunction.hashCode());
        return result;
    }

    public String toString() {
        return "RPForest(numTrees=" + this.getNumTrees() + ", trees=" + this.getTrees() + ", data=" + this.getData() + ", maxSize=" + this.getMaxSize() + ", similarityFunction=" + this.getSimilarityFunction() + ")";
    }
}

