/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.randomprojection;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class RPHyperPlanes {
    private int dim;
    private INDArray wholeHyperPlane;

    public RPHyperPlanes(int dim) {
        this.dim = dim;
    }

    public INDArray getHyperPlaneAt(int depth) {
        if (this.wholeHyperPlane.isVector()) {
            return this.wholeHyperPlane;
        }
        return this.wholeHyperPlane.slice((long)depth);
    }

    public void addRandomHyperPlane() {
        INDArray newPlane = Nd4j.randn((int[])new int[]{1, this.dim});
        newPlane.divi(newPlane.normmaxNumber());
        this.wholeHyperPlane = this.wholeHyperPlane == null ? newPlane : Nd4j.concat((int)0, (INDArray[])new INDArray[]{this.wholeHyperPlane, newPlane});
    }

    public int getDim() {
        return this.dim;
    }

    public INDArray getWholeHyperPlane() {
        return this.wholeHyperPlane;
    }

    public void setDim(int dim) {
        this.dim = dim;
    }

    public void setWholeHyperPlane(INDArray wholeHyperPlane) {
        this.wholeHyperPlane = wholeHyperPlane;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RPHyperPlanes)) {
            return false;
        }
        RPHyperPlanes other = (RPHyperPlanes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDim() != other.getDim()) {
            return false;
        }
        INDArray this$wholeHyperPlane = this.getWholeHyperPlane();
        INDArray other$wholeHyperPlane = other.getWholeHyperPlane();
        return !(this$wholeHyperPlane == null ? other$wholeHyperPlane != null : !this$wholeHyperPlane.equals(other$wholeHyperPlane));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RPHyperPlanes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDim();
        INDArray $wholeHyperPlane = this.getWholeHyperPlane();
        result = result * 59 + ($wholeHyperPlane == null ? 43 : $wholeHyperPlane.hashCode());
        return result;
    }

    public String toString() {
        return "RPHyperPlanes(dim=" + this.getDim() + ", wholeHyperPlane=" + this.getWholeHyperPlane() + ")";
    }
}

