/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.randomprojection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.deeplearning4j.clustering.randomprojection.RPTree;

public class RPNode {
    private int depth;
    private RPNode left;
    private RPNode right;
    private Future<RPNode> leftFuture;
    private Future<RPNode> rightFuture;
    private List<Integer> indices;
    private double median;
    private RPTree tree;

    public RPNode(RPTree tree, int depth) {
        this.depth = depth;
        this.tree = tree;
        this.indices = new ArrayList<Integer>();
    }

    public int getDepth() {
        return this.depth;
    }

    public RPNode getLeft() {
        return this.left;
    }

    public RPNode getRight() {
        return this.right;
    }

    public Future<RPNode> getLeftFuture() {
        return this.leftFuture;
    }

    public Future<RPNode> getRightFuture() {
        return this.rightFuture;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public double getMedian() {
        return this.median;
    }

    public RPTree getTree() {
        return this.tree;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setLeft(RPNode left) {
        this.left = left;
    }

    public void setRight(RPNode right) {
        this.right = right;
    }

    public void setLeftFuture(Future<RPNode> leftFuture) {
        this.leftFuture = leftFuture;
    }

    public void setRightFuture(Future<RPNode> rightFuture) {
        this.rightFuture = rightFuture;
    }

    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public void setTree(RPTree tree) {
        this.tree = tree;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RPNode)) {
            return false;
        }
        RPNode other = (RPNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        RPNode this$left = this.getLeft();
        RPNode other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        RPNode this$right = this.getRight();
        RPNode other$right = other.getRight();
        if (this$right == null ? other$right != null : !((Object)this$right).equals(other$right)) {
            return false;
        }
        Future<RPNode> this$leftFuture = this.getLeftFuture();
        Future<RPNode> other$leftFuture = other.getLeftFuture();
        if (this$leftFuture == null ? other$leftFuture != null : !this$leftFuture.equals(other$leftFuture)) {
            return false;
        }
        Future<RPNode> this$rightFuture = this.getRightFuture();
        Future<RPNode> other$rightFuture = other.getRightFuture();
        if (this$rightFuture == null ? other$rightFuture != null : !this$rightFuture.equals(other$rightFuture)) {
            return false;
        }
        List<Integer> this$indices = this.getIndices();
        List<Integer> other$indices = other.getIndices();
        if (this$indices == null ? other$indices != null : !((Object)this$indices).equals(other$indices)) {
            return false;
        }
        if (Double.compare(this.getMedian(), other.getMedian()) != 0) {
            return false;
        }
        RPTree this$tree = this.getTree();
        RPTree other$tree = other.getTree();
        return !(this$tree == null ? other$tree != null : !((Object)this$tree).equals(other$tree));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RPNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        RPNode $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        RPNode $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        Future<RPNode> $leftFuture = this.getLeftFuture();
        result = result * 59 + ($leftFuture == null ? 43 : $leftFuture.hashCode());
        Future<RPNode> $rightFuture = this.getRightFuture();
        result = result * 59 + ($rightFuture == null ? 43 : $rightFuture.hashCode());
        List<Integer> $indices = this.getIndices();
        result = result * 59 + ($indices == null ? 43 : ((Object)$indices).hashCode());
        long $median = Double.doubleToLongBits(this.getMedian());
        result = result * 59 + (int)($median >>> 32 ^ $median);
        RPTree $tree = this.getTree();
        result = result * 59 + ($tree == null ? 43 : ((Object)$tree).hashCode());
        return result;
    }

    public String toString() {
        return "RPNode(depth=" + this.getDepth() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ", leftFuture=" + this.getLeftFuture() + ", rightFuture=" + this.getRightFuture() + ", indices=" + this.getIndices() + ", median=" + this.getMedian() + ", tree=" + this.getTree() + ")";
    }
}

