/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.randomprojection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.deeplearning4j.clustering.randomprojection.RPHyperPlanes;
import org.deeplearning4j.clustering.randomprojection.RPNode;
import org.deeplearning4j.clustering.randomprojection.RPUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.memory.enums.MirroringPolicy;
import org.nd4j.linalg.api.memory.enums.ResetPolicy;
import org.nd4j.linalg.api.memory.enums.SpillPolicy;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RPTree {
    private RPNode root;
    private RPHyperPlanes rpHyperPlanes;
    private int dim;
    private int maxSize;
    private INDArray X;
    private String similarityFunction = "euclidean";
    private WorkspaceConfiguration workspaceConfiguration;
    private ExecutorService searchExecutor;
    private int searchWorkers;

    public RPTree(int dim, int maxSize, String similarityFunction) {
        this.dim = dim;
        this.maxSize = maxSize;
        this.rpHyperPlanes = new RPHyperPlanes(dim);
        this.root = new RPNode(this, 0);
        this.similarityFunction = similarityFunction;
        this.workspaceConfiguration = WorkspaceConfiguration.builder().cyclesBeforeInitialization(1).policyAllocation(AllocationPolicy.STRICT).policyLearning(LearningPolicy.FIRST_LOOP).policyMirroring(MirroringPolicy.FULL).policyReset(ResetPolicy.BLOCK_LEFT).policySpill(SpillPolicy.REALLOCATE).build();
    }

    public RPTree(int dim, int maxSize) {
        this(dim, maxSize, "euclidean");
    }

    public void buildTree(INDArray x) {
        this.X = x;
        for (int i = 0; i < x.rows(); ++i) {
            this.root.getIndices().add(i);
        }
        RPUtils.buildTree(this, this.root, this.rpHyperPlanes, x, this.maxSize, 0, this.similarityFunction);
    }

    public void addNodeAtIndex(int idx, INDArray toAdd) {
        RPNode query = RPUtils.query(this.root, this.rpHyperPlanes, toAdd, this.similarityFunction);
        query.getIndices().add(idx);
    }

    public List<RPNode> getLeaves() {
        ArrayList<RPNode> nodes = new ArrayList<RPNode>();
        RPUtils.scanForLeaves(nodes, this.getRoot());
        return nodes;
    }

    public List<Pair<Double, Integer>> queryWithDistances(INDArray query, int numResults) {
        return RPUtils.queryAllWithDistances(query, this.X, Arrays.asList(this), numResults, this.similarityFunction);
    }

    public INDArray query(INDArray query, int numResults) {
        return RPUtils.queryAll(query, this.X, Arrays.asList(this), numResults, this.similarityFunction);
    }

    public List<Integer> getCandidates(INDArray target) {
        return RPUtils.getCandidates(target, Arrays.asList(this), this.similarityFunction);
    }

    public static RPTreeBuilder builder() {
        return new RPTreeBuilder();
    }

    public RPNode getRoot() {
        return this.root;
    }

    public RPHyperPlanes getRpHyperPlanes() {
        return this.rpHyperPlanes;
    }

    public int getDim() {
        return this.dim;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public INDArray getX() {
        return this.X;
    }

    public String getSimilarityFunction() {
        return this.similarityFunction;
    }

    public WorkspaceConfiguration getWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    public ExecutorService getSearchExecutor() {
        return this.searchExecutor;
    }

    public int getSearchWorkers() {
        return this.searchWorkers;
    }

    public void setRoot(RPNode root) {
        this.root = root;
    }

    public void setRpHyperPlanes(RPHyperPlanes rpHyperPlanes) {
        this.rpHyperPlanes = rpHyperPlanes;
    }

    public void setDim(int dim) {
        this.dim = dim;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setX(INDArray X) {
        this.X = X;
    }

    public void setSimilarityFunction(String similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public void setWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration) {
        this.workspaceConfiguration = workspaceConfiguration;
    }

    public void setSearchExecutor(ExecutorService searchExecutor) {
        this.searchExecutor = searchExecutor;
    }

    public void setSearchWorkers(int searchWorkers) {
        this.searchWorkers = searchWorkers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RPTree)) {
            return false;
        }
        RPTree other = (RPTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RPNode this$root = this.getRoot();
        RPNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        RPHyperPlanes this$rpHyperPlanes = this.getRpHyperPlanes();
        RPHyperPlanes other$rpHyperPlanes = other.getRpHyperPlanes();
        if (this$rpHyperPlanes == null ? other$rpHyperPlanes != null : !((Object)this$rpHyperPlanes).equals(other$rpHyperPlanes)) {
            return false;
        }
        if (this.getDim() != other.getDim()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        INDArray this$X = this.getX();
        INDArray other$X = other.getX();
        if (this$X == null ? other$X != null : !this$X.equals(other$X)) {
            return false;
        }
        String this$similarityFunction = this.getSimilarityFunction();
        String other$similarityFunction = other.getSimilarityFunction();
        if (this$similarityFunction == null ? other$similarityFunction != null : !this$similarityFunction.equals(other$similarityFunction)) {
            return false;
        }
        WorkspaceConfiguration this$workspaceConfiguration = this.getWorkspaceConfiguration();
        WorkspaceConfiguration other$workspaceConfiguration = other.getWorkspaceConfiguration();
        if (this$workspaceConfiguration == null ? other$workspaceConfiguration != null : !this$workspaceConfiguration.equals(other$workspaceConfiguration)) {
            return false;
        }
        ExecutorService this$searchExecutor = this.getSearchExecutor();
        ExecutorService other$searchExecutor = other.getSearchExecutor();
        if (this$searchExecutor == null ? other$searchExecutor != null : !this$searchExecutor.equals(other$searchExecutor)) {
            return false;
        }
        return this.getSearchWorkers() == other.getSearchWorkers();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RPTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RPNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        RPHyperPlanes $rpHyperPlanes = this.getRpHyperPlanes();
        result = result * 59 + ($rpHyperPlanes == null ? 43 : ((Object)$rpHyperPlanes).hashCode());
        result = result * 59 + this.getDim();
        result = result * 59 + this.getMaxSize();
        INDArray $X = this.getX();
        result = result * 59 + ($X == null ? 43 : $X.hashCode());
        String $similarityFunction = this.getSimilarityFunction();
        result = result * 59 + ($similarityFunction == null ? 43 : $similarityFunction.hashCode());
        WorkspaceConfiguration $workspaceConfiguration = this.getWorkspaceConfiguration();
        result = result * 59 + ($workspaceConfiguration == null ? 43 : $workspaceConfiguration.hashCode());
        ExecutorService $searchExecutor = this.getSearchExecutor();
        result = result * 59 + ($searchExecutor == null ? 43 : $searchExecutor.hashCode());
        result = result * 59 + this.getSearchWorkers();
        return result;
    }

    public String toString() {
        return "RPTree(root=" + this.getRoot() + ", rpHyperPlanes=" + this.getRpHyperPlanes() + ", dim=" + this.getDim() + ", maxSize=" + this.getMaxSize() + ", X=" + this.getX() + ", similarityFunction=" + this.getSimilarityFunction() + ", workspaceConfiguration=" + this.getWorkspaceConfiguration() + ", searchExecutor=" + this.getSearchExecutor() + ", searchWorkers=" + this.getSearchWorkers() + ")";
    }

    public static class RPTreeBuilder {
        private int dim;
        private int maxSize;
        private String similarityFunction;

        RPTreeBuilder() {
        }

        public RPTreeBuilder dim(int dim) {
            this.dim = dim;
            return this;
        }

        public RPTreeBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public RPTreeBuilder similarityFunction(String similarityFunction) {
            this.similarityFunction = similarityFunction;
            return this;
        }

        public RPTree build() {
            return new RPTree(this.dim, this.maxSize, this.similarityFunction);
        }

        public String toString() {
            return "RPTree.RPTreeBuilder(dim=" + this.dim + ", maxSize=" + this.maxSize + ", similarityFunction=" + this.similarityFunction + ")";
        }
    }
}

