/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.sptree;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cell
implements Serializable {
    private int dimension;
    private INDArray corner;
    private INDArray width;

    public Cell(int dimension) {
        this.dimension = dimension;
    }

    public double corner(int d) {
        return this.corner.getDouble((long)d);
    }

    public double width(int d) {
        return this.width.getDouble((long)d);
    }

    public void setCorner(int d, double corner) {
        this.corner.putScalar((long)d, corner);
    }

    public void setWidth(int d, double width) {
        this.width.putScalar((long)d, width);
    }

    public void setWidth(INDArray width) {
        this.width = width;
    }

    public void setCorner(INDArray corner) {
        this.corner = corner;
    }

    public boolean contains(INDArray point) {
        INDArray cornerMinusWidth = this.corner.sub(this.width);
        INDArray cornerPlusWidth = this.corner.add(this.width);
        for (int d = 0; d < this.dimension; ++d) {
            double pointD = point.getDouble((long)d);
            if (cornerMinusWidth.getDouble((long)d) > pointD) {
                return false;
            }
            if (!(cornerPlusWidth.getDouble((long)d) < pointD)) continue;
            return false;
        }
        return true;
    }

    public INDArray width() {
        return this.width;
    }

    public INDArray corner() {
        return this.corner;
    }
}

