/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.sptree;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.reduce3.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.ManhattanDistance;
import org.nd4j.linalg.factory.Nd4j;

public class DataPoint
implements Serializable {
    private int index;
    private INDArray point;
    private long d;
    private String functionName;
    private boolean invert = false;

    public DataPoint(int index, INDArray point, boolean invert) {
        this(index, point, "euclidean");
        this.invert = invert;
    }

    public DataPoint(int index, INDArray point, String functionName, boolean invert) {
        this.index = index;
        this.point = point;
        this.functionName = functionName;
        this.d = point.length();
        this.invert = invert;
    }

    public DataPoint(int index, INDArray point) {
        this(index, point, false);
    }

    public DataPoint(int index, INDArray point, String functionName) {
        this(index, point, functionName, false);
    }

    public float distance(DataPoint point) {
        switch (this.functionName) {
            case "euclidean": {
                float ret = Nd4j.getExecutioner().execAndReturn((ReduceOp)new EuclideanDistance(this.point, point.point, new int[0])).getFinalResult().floatValue();
                return this.invert ? -ret : ret;
            }
            case "cosinesimilarity": {
                float ret2 = Nd4j.getExecutioner().execAndReturn((ReduceOp)new CosineSimilarity(this.point, point.point, new int[0])).getFinalResult().floatValue();
                return this.invert ? -ret2 : ret2;
            }
            case "manhattan": {
                float ret3 = Nd4j.getExecutioner().execAndReturn((ReduceOp)new ManhattanDistance(this.point, point.point, new int[0])).getFinalResult().floatValue();
                return this.invert ? -ret3 : ret3;
            }
            case "dot": {
                float dotRet = (float)Nd4j.getBlasWrapper().dot(this.point, point.point);
                return this.invert ? -dotRet : dotRet;
            }
        }
        float ret4 = Nd4j.getExecutioner().execAndReturn((ReduceOp)new EuclideanDistance(this.point, point.point, new int[0])).getFinalResult().floatValue();
        return this.invert ? -ret4 : ret4;
    }

    public int getIndex() {
        return this.index;
    }

    public INDArray getPoint() {
        return this.point;
    }

    public long getD() {
        return this.d;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPoint(INDArray point) {
        this.point = point;
    }

    public void setD(long d) {
        this.d = d;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPoint)) {
            return false;
        }
        DataPoint other = (DataPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        INDArray this$point = this.getPoint();
        INDArray other$point = other.getPoint();
        if (this$point == null ? other$point != null : !this$point.equals(other$point)) {
            return false;
        }
        if (this.getD() != other.getD()) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        return this.isInvert() == other.isInvert();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        INDArray $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        long $d = this.getD();
        result = result * 59 + (int)($d >>> 32 ^ $d);
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        result = result * 59 + (this.isInvert() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DataPoint(index=" + this.getIndex() + ", point=" + this.getPoint() + ", d=" + this.getD() + ", functionName=" + this.getFunctionName() + ", invert=" + this.isInvert() + ")";
    }
}

