/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.sptree;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class HeapObject
implements Serializable,
Comparable<HeapObject> {
    private int index;
    private INDArray point;
    private double distance;

    public HeapObject(int index, INDArray point, double distance) {
        this.index = index;
        this.point = point;
        this.distance = distance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeapObject heapObject = (HeapObject)o;
        if (!this.point.equals(heapObject.point)) {
            return false;
        }
        return Double.compare(heapObject.distance, this.distance) == 0;
    }

    public int hashCode() {
        int result = this.index;
        long temp = Double.doubleToLongBits(this.distance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(HeapObject o) {
        return this.distance < o.distance ? 1 : 0;
    }

    public int getIndex() {
        return this.index;
    }

    public INDArray getPoint() {
        return this.point;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPoint(INDArray point) {
        this.point = point;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public String toString() {
        return "HeapObject(index=" + this.getIndex() + ", point=" + this.getPoint() + ", distance=" + this.getDistance() + ")";
    }
}

