/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.strategy;

import java.io.Serializable;
import org.deeplearning4j.clustering.algorithm.Distance;
import org.deeplearning4j.clustering.condition.ClusteringAlgorithmCondition;
import org.deeplearning4j.clustering.condition.ConvergenceCondition;
import org.deeplearning4j.clustering.condition.FixedIterationCountCondition;
import org.deeplearning4j.clustering.strategy.ClusteringStrategy;
import org.deeplearning4j.clustering.strategy.ClusteringStrategyType;

public abstract class BaseClusteringStrategy
implements ClusteringStrategy,
Serializable {
    protected ClusteringStrategyType type;
    protected Integer initialClusterCount;
    protected ClusteringAlgorithmCondition optimizationPhaseCondition;
    protected ClusteringAlgorithmCondition terminationCondition;
    protected boolean inverse;
    protected Distance distanceFunction;
    protected boolean allowEmptyClusters;

    public BaseClusteringStrategy(ClusteringStrategyType type, Integer initialClusterCount, Distance distanceFunction, boolean allowEmptyClusters, boolean inverse) {
        this.type = type;
        this.initialClusterCount = initialClusterCount;
        this.distanceFunction = distanceFunction;
        this.allowEmptyClusters = allowEmptyClusters;
        this.inverse = inverse;
    }

    public BaseClusteringStrategy(ClusteringStrategyType clusteringStrategyType, int initialClusterCount, Distance distanceFunction, boolean inverse) {
        this(clusteringStrategyType, initialClusterCount, distanceFunction, false, inverse);
    }

    @Override
    public BaseClusteringStrategy endWhenIterationCountEquals(int maxIterationCount) {
        this.setTerminationCondition(FixedIterationCountCondition.iterationCountGreaterThan(maxIterationCount));
        return this;
    }

    @Override
    public BaseClusteringStrategy endWhenDistributionVariationRateLessThan(double rate) {
        this.setTerminationCondition(ConvergenceCondition.distributionVariationRateLessThan(rate));
        return this;
    }

    @Override
    public boolean inverseDistanceCalculation() {
        return this.inverse;
    }

    @Override
    public boolean isStrategyOfType(ClusteringStrategyType type) {
        return type.equals((Object)this.type);
    }

    @Override
    public Integer getInitialClusterCount() {
        return this.initialClusterCount;
    }

    protected BaseClusteringStrategy(ClusteringStrategyType type, Integer initialClusterCount, ClusteringAlgorithmCondition optimizationPhaseCondition, ClusteringAlgorithmCondition terminationCondition, boolean inverse, Distance distanceFunction, boolean allowEmptyClusters) {
        this.type = type;
        this.initialClusterCount = initialClusterCount;
        this.optimizationPhaseCondition = optimizationPhaseCondition;
        this.terminationCondition = terminationCondition;
        this.inverse = inverse;
        this.distanceFunction = distanceFunction;
        this.allowEmptyClusters = allowEmptyClusters;
    }

    protected BaseClusteringStrategy() {
    }

    @Override
    public ClusteringStrategyType getType() {
        return this.type;
    }

    protected void setType(ClusteringStrategyType type) {
        this.type = type;
    }

    protected void setInitialClusterCount(Integer initialClusterCount) {
        this.initialClusterCount = initialClusterCount;
    }

    public ClusteringAlgorithmCondition getOptimizationPhaseCondition() {
        return this.optimizationPhaseCondition;
    }

    protected void setOptimizationPhaseCondition(ClusteringAlgorithmCondition optimizationPhaseCondition) {
        this.optimizationPhaseCondition = optimizationPhaseCondition;
    }

    @Override
    public ClusteringAlgorithmCondition getTerminationCondition() {
        return this.terminationCondition;
    }

    protected void setTerminationCondition(ClusteringAlgorithmCondition terminationCondition) {
        this.terminationCondition = terminationCondition;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    protected void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    @Override
    public Distance getDistanceFunction() {
        return this.distanceFunction;
    }

    protected void setDistanceFunction(Distance distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    @Override
    public boolean isAllowEmptyClusters() {
        return this.allowEmptyClusters;
    }

    protected void setAllowEmptyClusters(boolean allowEmptyClusters) {
        this.allowEmptyClusters = allowEmptyClusters;
    }
}

