/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.vptree;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.clustering.sptree.DataPoint;
import org.deeplearning4j.clustering.vptree.VPTree;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class VPTreeFillSearch {
    private VPTree vpTree;
    private int k;
    private List<DataPoint> results;
    private List<Double> distances;
    private INDArray target;

    public VPTreeFillSearch(VPTree vpTree, int k, INDArray target) {
        this.vpTree = vpTree;
        this.k = k;
        this.target = target;
    }

    public void search() {
        this.results = new ArrayList<DataPoint>();
        this.distances = new ArrayList<Double>();
        INDArray distancesArr = Nd4j.create((int[])new int[]{this.vpTree.getItems().rows(), 1});
        this.vpTree.calcDistancesRelativeTo(this.target, distancesArr);
        INDArray[] sortWithIndices = Nd4j.sortWithIndices((INDArray)distancesArr, (int)0, (!this.vpTree.isInvert() ? 1 : 0) != 0);
        this.results.clear();
        this.distances.clear();
        if (this.vpTree.getItems().isVector()) {
            int i = 0;
            while (i < this.k) {
                int idx = sortWithIndices[0].getInt(new int[]{i++});
                this.results.add(new DataPoint(idx, Nd4j.scalar((double)this.vpTree.getItems().getDouble((long)idx))));
                this.distances.add(sortWithIndices[1].getDouble((long)idx));
            }
        } else {
            for (int i = 0; i < this.k; ++i) {
                int idx = sortWithIndices[0].getInt(new int[]{i});
                this.results.add(new DataPoint(idx, this.vpTree.getItems().getRow((long)idx)));
                this.distances.add(sortWithIndices[1].getDouble((long)i));
            }
        }
    }

    public List<DataPoint> getResults() {
        return this.results;
    }

    public List<Double> getDistances() {
        return this.distances;
    }
}

