/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.DeriveMessage;
import org.derive4j.processor.api.MessageLocalization;

public final class DeriveMessages {
    private DeriveMessages() {
    }

    public static DeriveMessage message(String msg, MessageLocalization localization) {
        return DeriveMessage.message(msg, localization);
    }

    public static DeriveMessage message(String msg) {
        return DeriveMessage.message(msg);
    }

    public static DeriveMessage message(String text, List<MessageLocalization> localizations) {
        return new Message(text, localizations);
    }

    public static DeriveMessage lazy(Supplier<DeriveMessage> deriveMessage) {
        return new Lazy(deriveMessage);
    }

    public static CasesMatchers.TotalMatcher_Message cases() {
        return CasesMatchers.totalMatcher_Message;
    }

    public static String getText(DeriveMessage deriveMessage) {
        return deriveMessage.match((text, localizations) -> text);
    }

    public static List<MessageLocalization> getLocalizations(DeriveMessage deriveMessage) {
        return deriveMessage.match((text, localizations) -> localizations);
    }

    public static Function<DeriveMessage, DeriveMessage> setText(String newText) {
        return DeriveMessages.modText(__ -> newText);
    }

    public static Function<DeriveMessage, DeriveMessage> modText(Function<String, String> textMod) {
        return deriveMessage -> deriveMessage.match((text, localizations) -> DeriveMessages.message((String)textMod.apply(text), localizations));
    }

    public static Function<DeriveMessage, DeriveMessage> setLocalizations(List<MessageLocalization> newLocalizations) {
        return DeriveMessages.modLocalizations(__ -> newLocalizations);
    }

    public static Function<DeriveMessage, DeriveMessage> modLocalizations(Function<List<MessageLocalization>, List<MessageLocalization>> localizationsMod) {
        return deriveMessage -> deriveMessage.match((text, localizations) -> DeriveMessages.message(text, (List)localizationsMod.apply(localizations)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Message totalMatcher_Message = new TotalMatcher_Message();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Message {
            TotalMatcher_Message() {
            }

            public final <R> Function<DeriveMessage, R> message(DeriveMessage.Case<R> message) {
                return deriveMessage -> deriveMessage.match(message);
            }

            public final <R> Function<DeriveMessage, R> message_(R r) {
                return this.message((text, localizations) -> r);
            }
        }
    }

    private static final class Lazy
    extends DeriveMessage {
        private volatile Supplier<DeriveMessage> expression;
        private DeriveMessage evaluation;

        Lazy(Supplier<DeriveMessage> deriveMessage) {
            this.expression = deriveMessage;
        }

        private synchronized DeriveMessage _evaluate() {
            block2: {
                DeriveMessage eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DeriveMessage> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(DeriveMessage.Case<R> message) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(message);
        }
    }

    private static final class Message
    extends DeriveMessage {
        private final String text;
        private final List<MessageLocalization> localizations;

        Message(String text, List<MessageLocalization> localizations) {
            this.text = text;
            this.localizations = localizations;
        }

        @Override
        public <R> R match(DeriveMessage.Case<R> message) {
            return message.message(this.text, this.localizations);
        }
    }
}

