/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.DeriveMessage;
import org.derive4j.processor.api.DeriveResult;

public final class DeriveResults {
    private DeriveResults() {
    }

    public static <A> DeriveResult<A> error(DeriveMessage error) {
        return new Error(error);
    }

    public static <A> DeriveResult<A> result(A result) {
        return new Result<A>(result);
    }

    public static <A> DeriveResult<A> lazy(Supplier<DeriveResult<A>> deriveResult) {
        return new Lazy<A>(deriveResult);
    }

    public static <A> CasesMatchers.TotalMatcher_Error<A> cases() {
        return CasesMatchers.totalMatcher_Error;
    }

    public static <A> CaseOfMatchers.TotalMatcher_Error<A> caseOf(DeriveResult<A> deriveResult) {
        return new CaseOfMatchers.TotalMatcher_Error<A>(deriveResult);
    }

    public static <A> Optional<DeriveMessage> getError(DeriveResult<A> deriveResult) {
        return deriveResult.match(error -> Optional.of(error), result -> Optional.empty());
    }

    public static <A> Optional<A> getResult(DeriveResult<A> deriveResult) {
        return deriveResult.match(error -> Optional.empty(), result -> Optional.of(result));
    }

    public static <A> Function<DeriveResult<A>, DeriveResult<A>> setError(DeriveMessage newError) {
        return DeriveResults.modError(__ -> newError);
    }

    public static <A> Function<DeriveResult<A>, DeriveResult<A>> modError(Function<DeriveMessage, DeriveMessage> errorMod) {
        return deriveResult -> deriveResult.match(error -> DeriveResults.error((DeriveMessage)errorMod.apply((DeriveMessage)error)), DeriveResults::result);
    }

    public static <A, RA> Function<DeriveResult<A>, DeriveResult<RA>> setResult(RA newResult) {
        return DeriveResults.modResult(__ -> newResult);
    }

    public static <A, RA> Function<DeriveResult<A>, DeriveResult<RA>> modResult(Function<A, RA> resultMod) {
        return deriveResult -> deriveResult.match(DeriveResults::error, result -> DeriveResults.result(resultMod.apply(result)));
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<A, R> {
            private final DeriveResult<A> _deriveResult;
            private final Function<DeriveMessage, R> error;
            private final Function<A, R> result;

            PartialMatcher(DeriveResult<A> _deriveResult, Function<DeriveMessage, R> error, Function<A, R> result) {
                this._deriveResult = _deriveResult;
                this.error = error;
                this.result = result;
            }

            public final R otherwise(Supplier<R> otherwise) {
                Function<DeriveMessage, Object> error = this.error != null ? this.error : error_ -> otherwise.get();
                Function<Object, Object> result = this.result != null ? this.result : result_ -> otherwise.get();
                return this._deriveResult.match(error, result);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                Function<DeriveMessage, Optional> error = this.error != null ? error_ -> Optional.of(this.error.apply((DeriveMessage)error_)) : error_ -> Optional.empty();
                Function<Object, Optional> result = this.result != null ? result_ -> Optional.of(this.result.apply(result_)) : result_ -> Optional.empty();
                return this._deriveResult.match(error, result);
            }
        }

        public static final class TotalMatcher_Result<A, R>
        extends PartialMatcher<A, R> {
            TotalMatcher_Result(DeriveResult<A> _deriveResult, Function<DeriveMessage, R> error) {
                super(_deriveResult, error, null);
            }

            public final R result(Function<A, R> result) {
                Function error = ((PartialMatcher)this).error;
                return ((PartialMatcher)this)._deriveResult.match(error, result);
            }

            public final R result_(R r) {
                return (R)this.result(result -> r);
            }
        }

        public static final class TotalMatcher_Error<A> {
            private final DeriveResult<A> _deriveResult;

            TotalMatcher_Error(DeriveResult<A> _deriveResult) {
                this._deriveResult = _deriveResult;
            }

            public final <R> TotalMatcher_Result<A, R> error(Function<DeriveMessage, R> error) {
                return new TotalMatcher_Result<A, R>(this._deriveResult, error);
            }

            public final <R> TotalMatcher_Result<A, R> error_(R r) {
                return this.error(error -> r);
            }

            public final <R> PartialMatcher<A, R> result(Function<A, R> result) {
                return new PartialMatcher<A, R>(this._deriveResult, null, result);
            }

            public final <R> PartialMatcher<A, R> result_(R r) {
                return this.result(result -> r);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Error<?> totalMatcher_Error = new TotalMatcher_Error();

        private CasesMatchers() {
        }

        public static class PartialMatcher<A, R> {
            private final Function<DeriveMessage, R> error;
            private final Function<A, R> result;

            PartialMatcher(Function<DeriveMessage, R> error, Function<A, R> result) {
                this.error = error;
                this.result = result;
            }

            public final Function<DeriveResult<A>, R> otherwise(Supplier<R> otherwise) {
                Function<DeriveMessage, Object> error = this.error != null ? this.error : error_ -> otherwise.get();
                Function<Object, Object> result = this.result != null ? this.result : result_ -> otherwise.get();
                return deriveResult -> deriveResult.match(error, result);
            }

            public final Function<DeriveResult<A>, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<DeriveResult<A>, Optional<R>> otherwiseEmpty() {
                Function<DeriveMessage, Optional> error = this.error != null ? error_ -> Optional.of(this.error.apply((DeriveMessage)error_)) : error_ -> Optional.empty();
                Function<Object, Optional> result = this.result != null ? result_ -> Optional.of(this.result.apply(result_)) : result_ -> Optional.empty();
                return deriveResult -> (Optional)deriveResult.match(error, result);
            }
        }

        public static final class TotalMatcher_Result<A, R>
        extends PartialMatcher<A, R> {
            TotalMatcher_Result(Function<DeriveMessage, R> error) {
                super(error, null);
            }

            public final Function<DeriveResult<A>, R> result(Function<A, R> result) {
                Function error = ((PartialMatcher)this).error;
                return deriveResult -> deriveResult.match(error, result);
            }

            public final Function<DeriveResult<A>, R> result_(R r) {
                return this.result(result -> r);
            }
        }

        public static final class TotalMatcher_Error<A> {
            TotalMatcher_Error() {
            }

            public final <R> TotalMatcher_Result<A, R> error(Function<DeriveMessage, R> error) {
                return new TotalMatcher_Result(error);
            }

            public final <R> TotalMatcher_Result<A, R> error_(R r) {
                return this.error(error -> r);
            }

            public final <R> PartialMatcher<A, R> result(Function<A, R> result) {
                return new PartialMatcher<A, R>(null, result);
            }

            public final <R> PartialMatcher<A, R> result_(R r) {
                return this.result(result -> r);
            }
        }
    }

    private static final class Lazy<A>
    extends DeriveResult<A> {
        private volatile Supplier<DeriveResult<A>> expression;
        private DeriveResult<A> evaluation;

        Lazy(Supplier<DeriveResult<A>> deriveResult) {
            this.expression = deriveResult;
        }

        private synchronized DeriveResult<A> _evaluate() {
            block2: {
                DeriveResult<A> eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DeriveResult<A>> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(Function<DeriveMessage, R> error, Function<A, R> result) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(error, result);
        }
    }

    private static final class Result<A>
    extends DeriveResult<A> {
        private final A result;

        Result(A result) {
            this.result = result;
        }

        @Override
        public <R> R match(Function<DeriveMessage, R> error, Function<A, R> result) {
            return result.apply(this.result);
        }
    }

    private static final class Error<A>
    extends DeriveResult<A> {
        private final DeriveMessage error;

        Error(DeriveMessage error) {
            this.error = error;
        }

        @Override
        public <R> R match(Function<DeriveMessage, R> error, Function<A, R> result) {
            return error.apply(this.error);
        }
    }
}

