/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.derive4j.Data;
import org.derive4j.processor.api.DerivedCodeSpecs;

@Data
public abstract class DerivedCodeSpec {
    public static DerivedCodeSpec codeSpec(TypeSpec classes, FieldSpec field, MethodSpec method) {
        return DerivedCodeSpecs.codeSpec(Collections.singletonList(classes), Collections.singletonList(field), Collections.singletonList(method));
    }

    public static DerivedCodeSpec codeSpec(TypeSpec clazz, MethodSpec method) {
        return DerivedCodeSpecs.codeSpec(Collections.singletonList(clazz), Collections.emptyList(), Collections.singletonList(method));
    }

    public static DerivedCodeSpec codeSpec(TypeSpec clazz, List<MethodSpec> methods) {
        return DerivedCodeSpecs.codeSpec(Collections.singletonList(clazz), Collections.emptyList(), methods);
    }

    public static DerivedCodeSpec codeSpec(FieldSpec field, MethodSpec method) {
        return DerivedCodeSpecs.codeSpec(Collections.emptyList(), Collections.singletonList(field), Collections.singletonList(method));
    }

    public static DerivedCodeSpec codeSpec(List<TypeSpec> classes, MethodSpec method) {
        return DerivedCodeSpecs.codeSpec(classes, Collections.emptyList(), Collections.singletonList(method));
    }

    public static DerivedCodeSpec codeSpec(List<TypeSpec> classes, FieldSpec field, MethodSpec method) {
        return DerivedCodeSpecs.codeSpec(classes, Collections.singletonList(field), Collections.singletonList(method));
    }

    public static DerivedCodeSpec methodSpecs(List<MethodSpec> methods) {
        return DerivedCodeSpecs.codeSpec(Collections.emptyList(), Collections.emptyList(), methods);
    }

    public static DerivedCodeSpec methodSpec(MethodSpec method) {
        return DerivedCodeSpec.methodSpecs(Collections.singletonList(method));
    }

    public static DerivedCodeSpec none() {
        return DerivedCodeSpec.methodSpecs(Collections.emptyList());
    }

    DerivedCodeSpec() {
    }

    public abstract <R> R match(Cases<R> var1);

    public final DerivedCodeSpec append(DerivedCodeSpec cs) {
        return DerivedCodeSpecs.codeSpec(DerivedCodeSpec.concat(this.classes(), cs.classes()), DerivedCodeSpec.concat(this.fields(), cs.fields()), DerivedCodeSpec.concat(this.methods(), cs.methods()));
    }

    public final List<TypeSpec> classes() {
        return DerivedCodeSpecs.getClasses(this);
    }

    public final List<FieldSpec> fields() {
        return DerivedCodeSpecs.getFields(this);
    }

    public final List<MethodSpec> methods() {
        return DerivedCodeSpecs.getMethods(this);
    }

    private static <A> List<A> concat(List<A> as1, List<A> as2) {
        return Stream.concat(as1.stream(), as2.stream()).collect(Collectors.toList());
    }

    public static interface Cases<R> {
        public R codeSpec(List<TypeSpec> var1, List<FieldSpec> var2, List<MethodSpec> var3);
    }
}

