/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.DerivedCodeSpec;

public final class DerivedCodeSpecs {
    private DerivedCodeSpecs() {
    }

    public static DerivedCodeSpec codeSpec(List<TypeSpec> classes, List<FieldSpec> fields, List<MethodSpec> methods) {
        return new CodeSpec(classes, fields, methods);
    }

    public static DerivedCodeSpec lazy(Supplier<DerivedCodeSpec> derivedCodeSpec) {
        return new Lazy(derivedCodeSpec);
    }

    public static CasesMatchers.TotalMatcher_CodeSpec cases() {
        return CasesMatchers.totalMatcher_CodeSpec;
    }

    public static List<TypeSpec> getClasses(DerivedCodeSpec derivedCodeSpec) {
        return derivedCodeSpec.match((classes, fields, methods) -> classes);
    }

    public static List<FieldSpec> getFields(DerivedCodeSpec derivedCodeSpec) {
        return derivedCodeSpec.match((classes, fields, methods) -> fields);
    }

    public static List<MethodSpec> getMethods(DerivedCodeSpec derivedCodeSpec) {
        return derivedCodeSpec.match((classes, fields, methods) -> methods);
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> setClasses(List<TypeSpec> newClasses) {
        return DerivedCodeSpecs.modClasses(__ -> newClasses);
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> modClasses(Function<List<TypeSpec>, List<TypeSpec>> classesMod) {
        return derivedCodeSpec -> derivedCodeSpec.match((classes, fields, methods) -> DerivedCodeSpecs.codeSpec((List)classesMod.apply(classes), fields, methods));
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> setFields(List<FieldSpec> newFields) {
        return DerivedCodeSpecs.modFields(__ -> newFields);
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> modFields(Function<List<FieldSpec>, List<FieldSpec>> fieldsMod) {
        return derivedCodeSpec -> derivedCodeSpec.match((classes, fields, methods) -> DerivedCodeSpecs.codeSpec(classes, (List)fieldsMod.apply(fields), methods));
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> setMethods(List<MethodSpec> newMethods) {
        return DerivedCodeSpecs.modMethods(__ -> newMethods);
    }

    public static Function<DerivedCodeSpec, DerivedCodeSpec> modMethods(Function<List<MethodSpec>, List<MethodSpec>> methodsMod) {
        return derivedCodeSpec -> derivedCodeSpec.match((classes, fields, methods) -> DerivedCodeSpecs.codeSpec(classes, fields, (List)methodsMod.apply(methods)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_CodeSpec totalMatcher_CodeSpec = new TotalMatcher_CodeSpec();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_CodeSpec {
            TotalMatcher_CodeSpec() {
            }

            public final <R> Function<DerivedCodeSpec, R> codeSpec(DerivedCodeSpec.Cases<R> codeSpec) {
                return derivedCodeSpec -> derivedCodeSpec.match(codeSpec);
            }

            public final <R> Function<DerivedCodeSpec, R> codeSpec_(R r) {
                return this.codeSpec((classes, fields, methods) -> r);
            }
        }
    }

    private static final class Lazy
    extends DerivedCodeSpec {
        private volatile Supplier<DerivedCodeSpec> expression;
        private DerivedCodeSpec evaluation;

        Lazy(Supplier<DerivedCodeSpec> derivedCodeSpec) {
            this.expression = derivedCodeSpec;
        }

        private synchronized DerivedCodeSpec _evaluate() {
            block2: {
                DerivedCodeSpec eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DerivedCodeSpec> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(DerivedCodeSpec.Cases<R> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }
    }

    private static final class CodeSpec
    extends DerivedCodeSpec {
        private final List<TypeSpec> classes;
        private final List<FieldSpec> fields;
        private final List<MethodSpec> methods;

        CodeSpec(List<TypeSpec> classes, List<FieldSpec> fields, List<MethodSpec> methods) {
            this.classes = classes;
            this.fields = fields;
            this.methods = methods;
        }

        @Override
        public <R> R match(DerivedCodeSpec.Cases<R> cases) {
            return cases.codeSpec(this.classes, this.fields, this.methods);
        }
    }
}

