/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.ClassName;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.derive4j.processor.api.InstanceLocation;

public final class InstanceLocations {
    private static final InstanceLocation.Cases<ClassName> classNameGetter = InstanceLocations.cases((className, variableElement) -> className, className -> className, (className, executableElement, typeArgs) -> className);
    private static final InstanceLocation.Cases<Optional<VariableElement>> variableElementGetter = InstanceLocations.cases((className, variableElement) -> Optional.of(variableElement), className -> Optional.empty(), (className, executableElement, typeArgs) -> Optional.empty());
    private static final InstanceLocation.Cases<Optional<ExecutableElement>> executableElementGetter = InstanceLocations.cases((className, variableElement) -> Optional.empty(), className -> Optional.empty(), (className, executableElement, typeArgs) -> Optional.of(executableElement));
    private static final InstanceLocation.Cases<Optional<Map<TypeVariable, TypeMirror>>> typeArgsGetter = InstanceLocations.cases((className, variableElement) -> Optional.empty(), className -> Optional.empty(), (className, executableElement, typeArgs) -> Optional.of(typeArgs));

    private InstanceLocations() {
    }

    public static <X> InstanceLocation.Cases<X> cases(ValueMapper<X> value, Function<ClassName, X> generatedIn, MethodMapper<X> method) {
        return new LambdaCases<X>(value, generatedIn, method);
    }

    public static InstanceLocation value(ClassName className, VariableElement variableElement) {
        return new Value(className, variableElement);
    }

    public static InstanceLocation generatedIn(ClassName className) {
        return new GeneratedIn(className);
    }

    public static InstanceLocation method(ClassName className, ExecutableElement executableElement, Map<TypeVariable, TypeMirror> typeArgs) {
        return new Method(className, executableElement, typeArgs);
    }

    public static InstanceLocation lazy(Supplier<InstanceLocation> instanceLocation) {
        return new Lazy(instanceLocation);
    }

    public static CasesMatchers.TotalMatcher_Value cases() {
        return CasesMatchers.totalMatcher_Value;
    }

    public static CaseOfMatchers.TotalMatcher_Value caseOf(InstanceLocation instanceLocation) {
        return new CaseOfMatchers.TotalMatcher_Value(instanceLocation);
    }

    public static ClassName getClassName(InstanceLocation instanceLocation) {
        return instanceLocation.match(classNameGetter);
    }

    public static Optional<VariableElement> getVariableElement(InstanceLocation instanceLocation) {
        return instanceLocation.match(variableElementGetter);
    }

    public static Optional<ExecutableElement> getExecutableElement(InstanceLocation instanceLocation) {
        return instanceLocation.match(executableElementGetter);
    }

    public static Optional<Map<TypeVariable, TypeMirror>> getTypeArgs(InstanceLocation instanceLocation) {
        return instanceLocation.match(typeArgsGetter);
    }

    public static Function<InstanceLocation, InstanceLocation> setClassName(ClassName newClassName) {
        return InstanceLocations.modClassName(__ -> newClassName);
    }

    public static Function<InstanceLocation, InstanceLocation> modClassName(Function<ClassName, ClassName> classNameMod) {
        InstanceLocation.Cases<InstanceLocation> cases = InstanceLocations.cases((className, variableElement) -> InstanceLocations.value((ClassName)classNameMod.apply(className), variableElement), className -> InstanceLocations.generatedIn((ClassName)classNameMod.apply((ClassName)className)), (className, executableElement, typeArgs) -> InstanceLocations.method((ClassName)classNameMod.apply(className), executableElement, typeArgs));
        return instanceLocation -> (InstanceLocation)instanceLocation.match(cases);
    }

    public static Function<InstanceLocation, InstanceLocation> setVariableElement(VariableElement newVariableElement) {
        return InstanceLocations.modVariableElement(__ -> newVariableElement);
    }

    public static Function<InstanceLocation, InstanceLocation> modVariableElement(Function<VariableElement, VariableElement> variableElementMod) {
        InstanceLocation.Cases<InstanceLocation> cases = InstanceLocations.cases((className, variableElement) -> InstanceLocations.value(className, (VariableElement)variableElementMod.apply(variableElement)), InstanceLocations::generatedIn, InstanceLocations::method);
        return instanceLocation -> (InstanceLocation)instanceLocation.match(cases);
    }

    public static Function<InstanceLocation, InstanceLocation> setExecutableElement(ExecutableElement newExecutableElement) {
        return InstanceLocations.modExecutableElement(__ -> newExecutableElement);
    }

    public static Function<InstanceLocation, InstanceLocation> modExecutableElement(Function<ExecutableElement, ExecutableElement> executableElementMod) {
        InstanceLocation.Cases<InstanceLocation> cases = InstanceLocations.cases(InstanceLocations::value, InstanceLocations::generatedIn, (className, executableElement, typeArgs) -> InstanceLocations.method(className, (ExecutableElement)executableElementMod.apply(executableElement), typeArgs));
        return instanceLocation -> (InstanceLocation)instanceLocation.match(cases);
    }

    public static Function<InstanceLocation, InstanceLocation> setTypeArgs(Map<TypeVariable, TypeMirror> newTypeArgs) {
        return InstanceLocations.modTypeArgs(__ -> newTypeArgs);
    }

    public static Function<InstanceLocation, InstanceLocation> modTypeArgs(Function<Map<TypeVariable, TypeMirror>, Map<TypeVariable, TypeMirror>> typeArgsMod) {
        InstanceLocation.Cases<InstanceLocation> cases = InstanceLocations.cases(InstanceLocations::value, InstanceLocations::generatedIn, (className, executableElement, typeArgs) -> InstanceLocations.method(className, executableElement, (Map)typeArgsMod.apply(typeArgs)));
        return instanceLocation -> (InstanceLocation)instanceLocation.match(cases);
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<X> {
            private final InstanceLocation _instanceLocation;
            private final ValueMapper<X> value;
            private final Function<ClassName, X> generatedIn;
            private final MethodMapper<X> method;

            PartialMatcher(InstanceLocation _instanceLocation, ValueMapper<X> value, Function<ClassName, X> generatedIn, MethodMapper<X> method) {
                this._instanceLocation = _instanceLocation;
                this.value = value;
                this.generatedIn = generatedIn;
                this.method = method;
            }

            public final X otherwise(Supplier<X> otherwise) {
                InstanceLocation.Cases<X> cases = InstanceLocations.cases(this.value != null ? this.value : (className, variableElement) -> otherwise.get(), this.generatedIn != null ? this.generatedIn : className -> otherwise.get(), this.method != null ? this.method : (className, executableElement, typeArgs) -> otherwise.get());
                return this._instanceLocation.match(cases);
            }

            public final X otherwise_(X x) {
                return (X)this.otherwise(() -> x);
            }

            public final Optional<X> otherwiseEmpty() {
                InstanceLocation.Cases<Optional> cases = InstanceLocations.cases(this.value != null ? (className, variableElement) -> Optional.of(this.value.value(className, variableElement)) : (className, variableElement) -> Optional.empty(), this.generatedIn != null ? className -> Optional.of(this.generatedIn.apply((ClassName)className)) : className -> Optional.empty(), this.method != null ? (className, executableElement, typeArgs) -> Optional.of(this.method.method(className, executableElement, typeArgs)) : (className, executableElement, typeArgs) -> Optional.empty());
                return this._instanceLocation.match(cases);
            }
        }

        public static class PartialMatcher_Method<X>
        extends PartialMatcher<X> {
            PartialMatcher_Method(InstanceLocation _instanceLocation, ValueMapper<X> value, Function<ClassName, X> generatedIn) {
                super(_instanceLocation, value, generatedIn, null);
            }

            public final PartialMatcher<X> method(MethodMapper<X> method) {
                return new PartialMatcher<X>(((PartialMatcher)this)._instanceLocation, ((PartialMatcher)this).value, ((PartialMatcher)this).generatedIn, method);
            }

            public final PartialMatcher<X> method_(X x) {
                return this.method((className, executableElement, typeArgs) -> x);
            }
        }

        public static final class TotalMatcher_Method<X>
        extends PartialMatcher<X> {
            TotalMatcher_Method(InstanceLocation _instanceLocation, ValueMapper<X> value, Function<ClassName, X> generatedIn) {
                super(_instanceLocation, value, generatedIn, null);
            }

            public final X method(MethodMapper<X> method) {
                InstanceLocation.Cases<X> cases = InstanceLocations.cases(((PartialMatcher)this).value, ((PartialMatcher)this).generatedIn, method);
                return ((PartialMatcher)this)._instanceLocation.match(cases);
            }

            public final X method_(X x) {
                return (X)this.method((className, executableElement, typeArgs) -> x);
            }
        }

        public static final class TotalMatcher_GeneratedIn<X>
        extends PartialMatcher_Method<X> {
            TotalMatcher_GeneratedIn(InstanceLocation _instanceLocation, ValueMapper<X> value) {
                super(_instanceLocation, value, null);
            }

            public final TotalMatcher_Method<X> generatedIn(Function<ClassName, X> generatedIn) {
                return new TotalMatcher_Method<X>(((PartialMatcher)this)._instanceLocation, ((PartialMatcher)this).value, generatedIn);
            }

            public final TotalMatcher_Method<X> generatedIn_(X x) {
                return this.generatedIn(className -> x);
            }
        }

        public static final class TotalMatcher_Value {
            private final InstanceLocation _instanceLocation;

            TotalMatcher_Value(InstanceLocation _instanceLocation) {
                this._instanceLocation = _instanceLocation;
            }

            public final <X> TotalMatcher_GeneratedIn<X> value(ValueMapper<X> value) {
                return new TotalMatcher_GeneratedIn<X>(this._instanceLocation, value);
            }

            public final <X> TotalMatcher_GeneratedIn<X> value_(X x) {
                return this.value((className, variableElement) -> x);
            }

            public final <X> PartialMatcher_Method<X> generatedIn(Function<ClassName, X> generatedIn) {
                return new PartialMatcher_Method<X>(this._instanceLocation, null, generatedIn);
            }

            public final <X> PartialMatcher_Method<X> generatedIn_(X x) {
                return this.generatedIn(className -> x);
            }

            public final <X> PartialMatcher<X> method(MethodMapper<X> method) {
                return new PartialMatcher<X>(this._instanceLocation, null, null, method);
            }

            public final <X> PartialMatcher<X> method_(X x) {
                return this.method((className, executableElement, typeArgs) -> x);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Value totalMatcher_Value = new TotalMatcher_Value();

        private CasesMatchers() {
        }

        public static class PartialMatcher<X> {
            private final ValueMapper<X> value;
            private final Function<ClassName, X> generatedIn;
            private final MethodMapper<X> method;

            PartialMatcher(ValueMapper<X> value, Function<ClassName, X> generatedIn, MethodMapper<X> method) {
                this.value = value;
                this.generatedIn = generatedIn;
                this.method = method;
            }

            public final Function<InstanceLocation, X> otherwise(Supplier<X> otherwise) {
                InstanceLocation.Cases cases = InstanceLocations.cases(this.value != null ? this.value : (className, variableElement) -> otherwise.get(), this.generatedIn != null ? this.generatedIn : className -> otherwise.get(), this.method != null ? this.method : (className, executableElement, typeArgs) -> otherwise.get());
                return instanceLocation -> instanceLocation.match(cases);
            }

            public final Function<InstanceLocation, X> otherwise_(X x) {
                return this.otherwise(() -> x);
            }

            public final Function<InstanceLocation, Optional<X>> otherwiseEmpty() {
                InstanceLocation.Cases<Optional> cases = InstanceLocations.cases(this.value != null ? (className, variableElement) -> Optional.of(this.value.value(className, variableElement)) : (className, variableElement) -> Optional.empty(), this.generatedIn != null ? className -> Optional.of(this.generatedIn.apply((ClassName)className)) : className -> Optional.empty(), this.method != null ? (className, executableElement, typeArgs) -> Optional.of(this.method.method(className, executableElement, typeArgs)) : (className, executableElement, typeArgs) -> Optional.empty());
                return instanceLocation -> (Optional)instanceLocation.match(cases);
            }
        }

        public static class PartialMatcher_Method<X>
        extends PartialMatcher<X> {
            PartialMatcher_Method(ValueMapper<X> value, Function<ClassName, X> generatedIn) {
                super(value, generatedIn, null);
            }

            public final PartialMatcher<X> method(MethodMapper<X> method) {
                return new PartialMatcher<X>(((PartialMatcher)this).value, ((PartialMatcher)this).generatedIn, method);
            }

            public final PartialMatcher<X> method_(X x) {
                return this.method((className, executableElement, typeArgs) -> x);
            }
        }

        public static final class TotalMatcher_Method<X>
        extends PartialMatcher<X> {
            TotalMatcher_Method(ValueMapper<X> value, Function<ClassName, X> generatedIn) {
                super(value, generatedIn, null);
            }

            public final Function<InstanceLocation, X> method(MethodMapper<X> method) {
                InstanceLocation.Cases cases = InstanceLocations.cases(((PartialMatcher)this).value, ((PartialMatcher)this).generatedIn, method);
                return instanceLocation -> instanceLocation.match(cases);
            }

            public final Function<InstanceLocation, X> method_(X x) {
                return this.method((className, executableElement, typeArgs) -> x);
            }
        }

        public static final class TotalMatcher_GeneratedIn<X>
        extends PartialMatcher_Method<X> {
            TotalMatcher_GeneratedIn(ValueMapper<X> value) {
                super(value, null);
            }

            public final TotalMatcher_Method<X> generatedIn(Function<ClassName, X> generatedIn) {
                return new TotalMatcher_Method<X>(((PartialMatcher)this).value, generatedIn);
            }

            public final TotalMatcher_Method<X> generatedIn_(X x) {
                return this.generatedIn(className -> x);
            }
        }

        public static final class TotalMatcher_Value {
            TotalMatcher_Value() {
            }

            public final <X> TotalMatcher_GeneratedIn<X> value(ValueMapper<X> value) {
                return new TotalMatcher_GeneratedIn<X>(value);
            }

            public final <X> TotalMatcher_GeneratedIn<X> value_(X x) {
                return this.value((className, variableElement) -> x);
            }

            public final <X> PartialMatcher_Method<X> generatedIn(Function<ClassName, X> generatedIn) {
                return new PartialMatcher_Method<X>(null, generatedIn);
            }

            public final <X> PartialMatcher_Method<X> generatedIn_(X x) {
                return this.generatedIn(className -> x);
            }

            public final <X> PartialMatcher<X> method(MethodMapper<X> method) {
                return new PartialMatcher<X>(null, null, method);
            }

            public final <X> PartialMatcher<X> method_(X x) {
                return this.method((className, executableElement, typeArgs) -> x);
            }
        }
    }

    private static final class Lazy
    extends InstanceLocation {
        private volatile Supplier<InstanceLocation> expression;
        private InstanceLocation evaluation;

        Lazy(Supplier<InstanceLocation> instanceLocation) {
            this.expression = instanceLocation;
        }

        private synchronized InstanceLocation _evaluate() {
            block2: {
                InstanceLocation eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<InstanceLocation> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(InstanceLocation.Cases<X> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }

        @Override
        public boolean equals(Object obj) {
            return (this.expression == null ? this.evaluation : this._evaluate()).equals(obj);
        }

        @Override
        public int hashCode() {
            return (this.expression == null ? this.evaluation : this._evaluate()).hashCode();
        }

        @Override
        public String toString() {
            return (this.expression == null ? this.evaluation : this._evaluate()).toString();
        }
    }

    private static final class Method
    extends InstanceLocation {
        private final ClassName className;
        private final ExecutableElement executableElement;
        private final Map<TypeVariable, TypeMirror> typeArgs;

        Method(ClassName className, ExecutableElement executableElement, Map<TypeVariable, TypeMirror> typeArgs) {
            this.className = className;
            this.executableElement = executableElement;
            this.typeArgs = typeArgs;
        }

        @Override
        public <X> X match(InstanceLocation.Cases<X> cases) {
            return cases.method(this.className, this.executableElement, this.typeArgs);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof InstanceLocation && ((InstanceLocation)obj).match(InstanceLocations.cases((className, variableElement) -> false, className -> false, (className, executableElement, typeArgs) -> this.className.equals((Object)className) && this.executableElement.equals(executableElement) && this.typeArgs.equals(typeArgs))) != false;
        }

        @Override
        public int hashCode() {
            return ((31 + this.className.hashCode()) * 31 + this.executableElement.hashCode()) * 31 + this.typeArgs.hashCode();
        }

        @Override
        public String toString() {
            return "method(" + this.className + ", " + this.executableElement + ", " + this.typeArgs + ")";
        }
    }

    private static final class GeneratedIn
    extends InstanceLocation {
        private final ClassName className;

        GeneratedIn(ClassName className) {
            this.className = className;
        }

        @Override
        public <X> X match(InstanceLocation.Cases<X> cases) {
            return cases.generatedIn(this.className);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof InstanceLocation && ((InstanceLocation)obj).match(InstanceLocations.cases((className, variableElement) -> false, className -> this.className.equals(className), (className, executableElement, typeArgs) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return 29 + this.className.hashCode();
        }

        @Override
        public String toString() {
            return "generatedIn(" + this.className + ")";
        }
    }

    private static final class Value
    extends InstanceLocation {
        private final ClassName className;
        private final VariableElement variableElement;

        Value(ClassName className, VariableElement variableElement) {
            this.className = className;
            this.variableElement = variableElement;
        }

        @Override
        public <X> X match(InstanceLocation.Cases<X> cases) {
            return cases.value(this.className, this.variableElement);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof InstanceLocation && ((InstanceLocation)obj).match(InstanceLocations.cases((className, variableElement) -> this.className.equals((Object)className) && this.variableElement.equals(variableElement), className -> false, (className, executableElement, typeArgs) -> false)) != false;
        }

        @Override
        public int hashCode() {
            return (23 + this.className.hashCode()) * 23 + this.variableElement.hashCode();
        }

        @Override
        public String toString() {
            return "value(" + this.className + ", " + this.variableElement + ")";
        }
    }

    private static final class LambdaCases<X>
    implements InstanceLocation.Cases<X> {
        private final ValueMapper<X> value;
        private final Function<ClassName, X> generatedIn;
        private final MethodMapper<X> method;

        LambdaCases(ValueMapper<X> value, Function<ClassName, X> generatedIn, MethodMapper<X> method) {
            this.value = value;
            this.generatedIn = generatedIn;
            this.method = method;
        }

        @Override
        public X value(ClassName className, VariableElement variableElement) {
            return this.value.value(className, variableElement);
        }

        @Override
        public X generatedIn(ClassName className) {
            return this.generatedIn.apply(className);
        }

        @Override
        public X method(ClassName className, ExecutableElement executableElement, Map<TypeVariable, TypeMirror> typeArgs) {
            return this.method.method(className, executableElement, typeArgs);
        }
    }

    public static interface MethodMapper<X> {
        public X method(ClassName var1, ExecutableElement var2, Map<TypeVariable, TypeMirror> var3);
    }

    public static interface ValueMapper<X> {
        public X value(ClassName var1, VariableElement var2);
    }
}

