/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.derive4j.processor.api.MessageLocalization;

public final class MessageLocalizations {
    private static final MessageLocalization.Cases<Element> elementGetter = MessageLocalizations.cases(element -> element, (element, annotation) -> element, (element, annotation, annotationValue) -> element);
    private static final MessageLocalization.Cases<Optional<AnnotationMirror>> annotationGetter = MessageLocalizations.cases(element -> Optional.empty(), (element, annotation) -> Optional.of(annotation), (element, annotation, annotationValue) -> Optional.of(annotation));
    private static final MessageLocalization.Cases<Optional<AnnotationValue>> annotationValueGetter = MessageLocalizations.cases(element -> Optional.empty(), (element, annotation) -> Optional.empty(), (element, annotation, annotationValue) -> Optional.of(annotationValue));

    private MessageLocalizations() {
    }

    public static <R> MessageLocalization.Cases<R> cases(Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation, OnAnnotationValueMapper<R> onAnnotationValue) {
        return new LambdaCases<R>(onElement, onAnnotation, onAnnotationValue);
    }

    public static MessageLocalization onElement(Element element) {
        return new OnElement(element);
    }

    public static MessageLocalization onAnnotation(Element element, AnnotationMirror annotation) {
        return new OnAnnotation(element, annotation);
    }

    public static MessageLocalization onAnnotationValue(Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
        return new OnAnnotationValue(element, annotation, annotationValue);
    }

    public static MessageLocalization lazy(Supplier<MessageLocalization> messageLocalization) {
        return new Lazy(messageLocalization);
    }

    public static CasesMatchers.TotalMatcher_OnElement cases() {
        return CasesMatchers.totalMatcher_OnElement;
    }

    public static CaseOfMatchers.TotalMatcher_OnElement caseOf(MessageLocalization messageLocalization) {
        return new CaseOfMatchers.TotalMatcher_OnElement(messageLocalization);
    }

    public static Element getElement(MessageLocalization messageLocalization) {
        return messageLocalization.match(elementGetter);
    }

    public static Optional<AnnotationMirror> getAnnotation(MessageLocalization messageLocalization) {
        return messageLocalization.match(annotationGetter);
    }

    public static Optional<AnnotationValue> getAnnotationValue(MessageLocalization messageLocalization) {
        return messageLocalization.match(annotationValueGetter);
    }

    public static Function<MessageLocalization, MessageLocalization> setElement(Element newElement) {
        return MessageLocalizations.modElement(__ -> newElement);
    }

    public static Function<MessageLocalization, MessageLocalization> modElement(Function<Element, Element> elementMod) {
        MessageLocalization.Cases<MessageLocalization> cases = MessageLocalizations.cases(element -> MessageLocalizations.onElement((Element)elementMod.apply((Element)element)), (element, annotation) -> MessageLocalizations.onAnnotation((Element)elementMod.apply(element), annotation), (element, annotation, annotationValue) -> MessageLocalizations.onAnnotationValue((Element)elementMod.apply(element), annotation, annotationValue));
        return messageLocalization -> (MessageLocalization)messageLocalization.match(cases);
    }

    public static Function<MessageLocalization, MessageLocalization> setAnnotation(AnnotationMirror newAnnotation) {
        return MessageLocalizations.modAnnotation(__ -> newAnnotation);
    }

    public static Function<MessageLocalization, MessageLocalization> modAnnotation(Function<AnnotationMirror, AnnotationMirror> annotationMod) {
        MessageLocalization.Cases<MessageLocalization> cases = MessageLocalizations.cases(MessageLocalizations::onElement, (element, annotation) -> MessageLocalizations.onAnnotation(element, (AnnotationMirror)annotationMod.apply(annotation)), (element, annotation, annotationValue) -> MessageLocalizations.onAnnotationValue(element, (AnnotationMirror)annotationMod.apply(annotation), annotationValue));
        return messageLocalization -> (MessageLocalization)messageLocalization.match(cases);
    }

    public static Function<MessageLocalization, MessageLocalization> setAnnotationValue(AnnotationValue newAnnotationValue) {
        return MessageLocalizations.modAnnotationValue(__ -> newAnnotationValue);
    }

    public static Function<MessageLocalization, MessageLocalization> modAnnotationValue(Function<AnnotationValue, AnnotationValue> annotationValueMod) {
        MessageLocalization.Cases<MessageLocalization> cases = MessageLocalizations.cases(MessageLocalizations::onElement, MessageLocalizations::onAnnotation, (element, annotation, annotationValue) -> MessageLocalizations.onAnnotationValue(element, annotation, (AnnotationValue)annotationValueMod.apply(annotationValue)));
        return messageLocalization -> (MessageLocalization)messageLocalization.match(cases);
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<R> {
            private final MessageLocalization _messageLocalization;
            private final Function<Element, R> onElement;
            private final OnAnnotationMapper<R> onAnnotation;
            private final OnAnnotationValueMapper<R> onAnnotationValue;

            PartialMatcher(MessageLocalization _messageLocalization, Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation, OnAnnotationValueMapper<R> onAnnotationValue) {
                this._messageLocalization = _messageLocalization;
                this.onElement = onElement;
                this.onAnnotation = onAnnotation;
                this.onAnnotationValue = onAnnotationValue;
            }

            public final R otherwise(Supplier<R> otherwise) {
                MessageLocalization.Cases<R> cases = MessageLocalizations.cases(this.onElement != null ? this.onElement : element -> otherwise.get(), this.onAnnotation != null ? this.onAnnotation : (element, annotation) -> otherwise.get(), this.onAnnotationValue != null ? this.onAnnotationValue : (element, annotation, annotationValue) -> otherwise.get());
                return this._messageLocalization.match(cases);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                MessageLocalization.Cases<Optional> cases = MessageLocalizations.cases(this.onElement != null ? element -> Optional.of(this.onElement.apply((Element)element)) : element -> Optional.empty(), this.onAnnotation != null ? (element, annotation) -> Optional.of(this.onAnnotation.onAnnotation(element, annotation)) : (element, annotation) -> Optional.empty(), this.onAnnotationValue != null ? (element, annotation, annotationValue) -> Optional.of(this.onAnnotationValue.onAnnotationValue(element, annotation, annotationValue)) : (element, annotation, annotationValue) -> Optional.empty());
                return this._messageLocalization.match(cases);
            }
        }

        public static class PartialMatcher_OnAnnotationValue<R>
        extends PartialMatcher<R> {
            PartialMatcher_OnAnnotationValue(MessageLocalization _messageLocalization, Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation) {
                super(_messageLocalization, onElement, onAnnotation, null);
            }

            public final PartialMatcher<R> onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                return new PartialMatcher<R>(((PartialMatcher)this)._messageLocalization, ((PartialMatcher)this).onElement, ((PartialMatcher)this).onAnnotation, onAnnotationValue);
            }

            public final PartialMatcher<R> onAnnotationValue_(R r) {
                return this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }

        public static final class TotalMatcher_OnAnnotationValue<R>
        extends PartialMatcher<R> {
            TotalMatcher_OnAnnotationValue(MessageLocalization _messageLocalization, Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation) {
                super(_messageLocalization, onElement, onAnnotation, null);
            }

            public final R onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                MessageLocalization.Cases<R> cases = MessageLocalizations.cases(((PartialMatcher)this).onElement, ((PartialMatcher)this).onAnnotation, onAnnotationValue);
                return ((PartialMatcher)this)._messageLocalization.match(cases);
            }

            public final R onAnnotationValue_(R r) {
                return (R)this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }

        public static final class TotalMatcher_OnAnnotation<R>
        extends PartialMatcher_OnAnnotationValue<R> {
            TotalMatcher_OnAnnotation(MessageLocalization _messageLocalization, Function<Element, R> onElement) {
                super(_messageLocalization, onElement, null);
            }

            public final TotalMatcher_OnAnnotationValue<R> onAnnotation(OnAnnotationMapper<R> onAnnotation) {
                return new TotalMatcher_OnAnnotationValue<R>(((PartialMatcher)this)._messageLocalization, ((PartialMatcher)this).onElement, onAnnotation);
            }

            public final TotalMatcher_OnAnnotationValue<R> onAnnotation_(R r) {
                return this.onAnnotation((element, annotation) -> r);
            }
        }

        public static final class TotalMatcher_OnElement {
            private final MessageLocalization _messageLocalization;

            TotalMatcher_OnElement(MessageLocalization _messageLocalization) {
                this._messageLocalization = _messageLocalization;
            }

            public final <R> TotalMatcher_OnAnnotation<R> onElement(Function<Element, R> onElement) {
                return new TotalMatcher_OnAnnotation<R>(this._messageLocalization, onElement);
            }

            public final <R> TotalMatcher_OnAnnotation<R> onElement_(R r) {
                return this.onElement(element -> r);
            }

            public final <R> PartialMatcher_OnAnnotationValue<R> onAnnotation(OnAnnotationMapper<R> onAnnotation) {
                return new PartialMatcher_OnAnnotationValue<R>(this._messageLocalization, null, onAnnotation);
            }

            public final <R> PartialMatcher_OnAnnotationValue<R> onAnnotation_(R r) {
                return this.onAnnotation((element, annotation) -> r);
            }

            public final <R> PartialMatcher<R> onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                return new PartialMatcher<R>(this._messageLocalization, null, null, onAnnotationValue);
            }

            public final <R> PartialMatcher<R> onAnnotationValue_(R r) {
                return this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_OnElement totalMatcher_OnElement = new TotalMatcher_OnElement();

        private CasesMatchers() {
        }

        public static class PartialMatcher<R> {
            private final Function<Element, R> onElement;
            private final OnAnnotationMapper<R> onAnnotation;
            private final OnAnnotationValueMapper<R> onAnnotationValue;

            PartialMatcher(Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation, OnAnnotationValueMapper<R> onAnnotationValue) {
                this.onElement = onElement;
                this.onAnnotation = onAnnotation;
                this.onAnnotationValue = onAnnotationValue;
            }

            public final Function<MessageLocalization, R> otherwise(Supplier<R> otherwise) {
                MessageLocalization.Cases cases = MessageLocalizations.cases(this.onElement != null ? this.onElement : element -> otherwise.get(), this.onAnnotation != null ? this.onAnnotation : (element, annotation) -> otherwise.get(), this.onAnnotationValue != null ? this.onAnnotationValue : (element, annotation, annotationValue) -> otherwise.get());
                return messageLocalization -> messageLocalization.match(cases);
            }

            public final Function<MessageLocalization, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<MessageLocalization, Optional<R>> otherwiseEmpty() {
                MessageLocalization.Cases<Optional> cases = MessageLocalizations.cases(this.onElement != null ? element -> Optional.of(this.onElement.apply((Element)element)) : element -> Optional.empty(), this.onAnnotation != null ? (element, annotation) -> Optional.of(this.onAnnotation.onAnnotation(element, annotation)) : (element, annotation) -> Optional.empty(), this.onAnnotationValue != null ? (element, annotation, annotationValue) -> Optional.of(this.onAnnotationValue.onAnnotationValue(element, annotation, annotationValue)) : (element, annotation, annotationValue) -> Optional.empty());
                return messageLocalization -> (Optional)messageLocalization.match(cases);
            }
        }

        public static class PartialMatcher_OnAnnotationValue<R>
        extends PartialMatcher<R> {
            PartialMatcher_OnAnnotationValue(Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation) {
                super(onElement, onAnnotation, null);
            }

            public final PartialMatcher<R> onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                return new PartialMatcher<R>(((PartialMatcher)this).onElement, ((PartialMatcher)this).onAnnotation, onAnnotationValue);
            }

            public final PartialMatcher<R> onAnnotationValue_(R r) {
                return this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }

        public static final class TotalMatcher_OnAnnotationValue<R>
        extends PartialMatcher<R> {
            TotalMatcher_OnAnnotationValue(Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation) {
                super(onElement, onAnnotation, null);
            }

            public final Function<MessageLocalization, R> onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                MessageLocalization.Cases cases = MessageLocalizations.cases(((PartialMatcher)this).onElement, ((PartialMatcher)this).onAnnotation, onAnnotationValue);
                return messageLocalization -> messageLocalization.match(cases);
            }

            public final Function<MessageLocalization, R> onAnnotationValue_(R r) {
                return this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }

        public static final class TotalMatcher_OnAnnotation<R>
        extends PartialMatcher_OnAnnotationValue<R> {
            TotalMatcher_OnAnnotation(Function<Element, R> onElement) {
                super(onElement, null);
            }

            public final TotalMatcher_OnAnnotationValue<R> onAnnotation(OnAnnotationMapper<R> onAnnotation) {
                return new TotalMatcher_OnAnnotationValue<R>(((PartialMatcher)this).onElement, onAnnotation);
            }

            public final TotalMatcher_OnAnnotationValue<R> onAnnotation_(R r) {
                return this.onAnnotation((element, annotation) -> r);
            }
        }

        public static final class TotalMatcher_OnElement {
            TotalMatcher_OnElement() {
            }

            public final <R> TotalMatcher_OnAnnotation<R> onElement(Function<Element, R> onElement) {
                return new TotalMatcher_OnAnnotation<R>(onElement);
            }

            public final <R> TotalMatcher_OnAnnotation<R> onElement_(R r) {
                return this.onElement(element -> r);
            }

            public final <R> PartialMatcher_OnAnnotationValue<R> onAnnotation(OnAnnotationMapper<R> onAnnotation) {
                return new PartialMatcher_OnAnnotationValue<R>(null, onAnnotation);
            }

            public final <R> PartialMatcher_OnAnnotationValue<R> onAnnotation_(R r) {
                return this.onAnnotation((element, annotation) -> r);
            }

            public final <R> PartialMatcher<R> onAnnotationValue(OnAnnotationValueMapper<R> onAnnotationValue) {
                return new PartialMatcher<R>(null, null, onAnnotationValue);
            }

            public final <R> PartialMatcher<R> onAnnotationValue_(R r) {
                return this.onAnnotationValue((element, annotation, annotationValue) -> r);
            }
        }
    }

    private static final class Lazy
    extends MessageLocalization {
        private volatile Supplier<MessageLocalization> expression;
        private MessageLocalization evaluation;

        Lazy(Supplier<MessageLocalization> messageLocalization) {
            this.expression = messageLocalization;
        }

        private synchronized MessageLocalization _evaluate() {
            block2: {
                MessageLocalization eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<MessageLocalization> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(MessageLocalization.Cases<R> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }
    }

    private static final class OnAnnotationValue
    extends MessageLocalization {
        private final Element element;
        private final AnnotationMirror annotation;
        private final AnnotationValue annotationValue;

        OnAnnotationValue(Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            this.element = element;
            this.annotation = annotation;
            this.annotationValue = annotationValue;
        }

        @Override
        public <R> R match(MessageLocalization.Cases<R> cases) {
            return cases.onAnnotationValue(this.element, this.annotation, this.annotationValue);
        }
    }

    private static final class OnAnnotation
    extends MessageLocalization {
        private final Element element;
        private final AnnotationMirror annotation;

        OnAnnotation(Element element, AnnotationMirror annotation) {
            this.element = element;
            this.annotation = annotation;
        }

        @Override
        public <R> R match(MessageLocalization.Cases<R> cases) {
            return cases.onAnnotation(this.element, this.annotation);
        }
    }

    private static final class OnElement
    extends MessageLocalization {
        private final Element element;

        OnElement(Element element) {
            this.element = element;
        }

        @Override
        public <R> R match(MessageLocalization.Cases<R> cases) {
            return cases.onElement(this.element);
        }
    }

    private static final class LambdaCases<R>
    implements MessageLocalization.Cases<R> {
        private final Function<Element, R> onElement;
        private final OnAnnotationMapper<R> onAnnotation;
        private final OnAnnotationValueMapper<R> onAnnotationValue;

        LambdaCases(Function<Element, R> onElement, OnAnnotationMapper<R> onAnnotation, OnAnnotationValueMapper<R> onAnnotationValue) {
            this.onElement = onElement;
            this.onAnnotation = onAnnotation;
            this.onAnnotationValue = onAnnotationValue;
        }

        @Override
        public R onElement(Element element) {
            return this.onElement.apply(element);
        }

        @Override
        public R onAnnotation(Element element, AnnotationMirror annotation) {
            return this.onAnnotation.onAnnotation(element, annotation);
        }

        @Override
        public R onAnnotationValue(Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.onAnnotationValue.onAnnotationValue(element, annotation, annotationValue);
        }
    }

    public static interface OnAnnotationValueMapper<R> {
        public R onAnnotationValue(Element var1, AnnotationMirror var2, AnnotationValue var3);
    }

    public static interface OnAnnotationMapper<R> {
        public R onAnnotation(Element var1, AnnotationMirror var2);
    }
}

