/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class TypeSpecModifier {
    private final TypeSpec.Kind kind;
    private final String name;
    private CodeBlock javadoc;
    private List<AnnotationSpec> annotations;
    private Set<Modifier> modifiers;
    private List<TypeVariableName> typeVariables;
    private TypeName superclass;
    private List<TypeName> superinterfaces;
    private Map<String, TypeSpec> enumConstants;
    private List<FieldSpec> fieldSpecs;
    private List<MethodSpec> methodSpecs;
    private List<TypeSpec> typeSpecs;
    private final List<Element> originatingElements;

    public TypeSpecModifier(TypeSpec typeSpec) {
        this.kind = typeSpec.kind;
        this.name = typeSpec.name;
        this.javadoc = typeSpec.javadoc;
        this.annotations = typeSpec.annotations;
        this.modifiers = typeSpec.modifiers;
        this.typeVariables = typeSpec.typeVariables;
        this.superclass = typeSpec.superclass;
        this.superinterfaces = typeSpec.superinterfaces;
        this.enumConstants = typeSpec.enumConstants;
        this.fieldSpecs = typeSpec.fieldSpecs;
        this.methodSpecs = typeSpec.methodSpecs;
        this.typeSpecs = typeSpec.typeSpecs;
        this.originatingElements = typeSpec.originatingElements;
    }

    public TypeSpec build() {
        TypeSpec.Builder builder;
        switch (this.kind) {
            case ANNOTATION: {
                builder = TypeSpec.annotationBuilder((String)this.name);
                break;
            }
            case CLASS: {
                builder = TypeSpec.classBuilder((String)this.name);
                break;
            }
            case ENUM: {
                builder = TypeSpec.enumBuilder((String)this.name);
                break;
            }
            case INTERFACE: {
                builder = TypeSpec.interfaceBuilder((String)this.name);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown kind: " + this.kind);
            }
        }
        builder.addAnnotations(this.annotations).addModifiers(this.modifiers.toArray(new Modifier[0])).addTypeVariables(this.typeVariables).superclass(this.superclass).addSuperinterfaces(this.superinterfaces);
        this.enumConstants.forEach((arg_0, arg_1) -> ((TypeSpec.Builder)builder).addEnumConstant(arg_0, arg_1));
        builder.addFields(this.fieldSpecs).addMethods(this.methodSpecs).addTypes(this.typeSpecs);
        this.originatingElements.forEach(arg_0 -> ((TypeSpec.Builder)builder).addOriginatingElement(arg_0));
        return builder.build();
    }

    public TypeSpecModifier modJavadoc(UnaryOperator<CodeBlock> modJavadoc) {
        this.javadoc = (CodeBlock)modJavadoc.apply(this.javadoc);
        return this;
    }

    public TypeSpecModifier modAnnotations(UnaryOperator<List<AnnotationSpec>> modAnnotations) {
        this.annotations = (List)modAnnotations.apply(this.annotations);
        return this;
    }

    public TypeSpecModifier modModifiers(UnaryOperator<Set<Modifier>> modModifiers) {
        this.modifiers = (Set)modModifiers.apply(this.modifiers);
        return this;
    }

    public TypeSpecModifier modTypeVariables(UnaryOperator<List<TypeVariableName>> modTypeVariables) {
        this.typeVariables = (List)modTypeVariables.apply(this.typeVariables);
        return this;
    }

    public TypeSpecModifier modSuperclass(TypeName superclass) {
        this.superclass = superclass;
        return this;
    }

    public TypeSpecModifier modSuperinterfaces(UnaryOperator<List<TypeName>> modSuperinterfaces) {
        this.superinterfaces = (List)modSuperinterfaces.apply(this.superinterfaces);
        return this;
    }

    public TypeSpecModifier modEnumConstants(UnaryOperator<Map<String, TypeSpec>> modEnumConstants) {
        this.enumConstants = (Map)modEnumConstants.apply(this.enumConstants);
        return this;
    }

    public TypeSpecModifier modFields(UnaryOperator<List<FieldSpec>> modFields) {
        this.fieldSpecs = (List)modFields.apply(this.fieldSpecs);
        return this;
    }

    public TypeSpecModifier modMethods(UnaryOperator<List<MethodSpec>> modMethods) {
        this.methodSpecs = (List)modMethods.apply(this.methodSpecs);
        return this;
    }

    public TypeSpecModifier modTypes(UnaryOperator<List<TypeSpec>> modTypes) {
        this.typeSpecs = (List)modTypes.apply(this.typeSpecs);
        return this;
    }
}

