/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.processor.api.model.DataConstruction;
import org.derive4j.processor.api.model.DataConstructor;
import org.derive4j.processor.api.model.MultipleConstructors;

public final class DataConstructions {
    private static DataConstruction noConstructor;
    private static final DataConstruction.Cases<Optional<MultipleConstructors>> constructorsGetter;
    private static final DataConstruction.Cases<Optional<DataConstructor>> constructorGetter;

    private DataConstructions() {
    }

    public static <R> DataConstruction.Cases<R> cases(Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor, Supplier<R> noConstructor) {
        return new LambdaCases<R>(multipleConstructors, oneConstructor, noConstructor);
    }

    public static DataConstruction multipleConstructors(MultipleConstructors constructors) {
        return new MultipleConstructors_(constructors);
    }

    public static DataConstruction oneConstructor(DataConstructor constructor) {
        return new OneConstructor(constructor);
    }

    public static DataConstruction noConstructor() {
        DataConstruction _noConstructor = noConstructor;
        if (_noConstructor == null) {
            noConstructor = _noConstructor = new NoConstructor();
        }
        return _noConstructor;
    }

    public static DataConstruction lazy(Supplier<DataConstruction> dataConstruction) {
        return new Lazy(dataConstruction);
    }

    public static CasesMatchers.TotalMatcher_MultipleConstructors cases() {
        return CasesMatchers.totalMatcher_MultipleConstructors;
    }

    public static CaseOfMatchers.TotalMatcher_MultipleConstructors caseOf(DataConstruction dataConstruction) {
        return new CaseOfMatchers.TotalMatcher_MultipleConstructors(dataConstruction);
    }

    public static Optional<MultipleConstructors> getConstructors(DataConstruction dataConstruction) {
        return dataConstruction.match(constructorsGetter);
    }

    public static Optional<DataConstructor> getConstructor(DataConstruction dataConstruction) {
        return dataConstruction.match(constructorGetter);
    }

    public static Function<DataConstruction, DataConstruction> setConstructors(MultipleConstructors newConstructors) {
        return DataConstructions.modConstructors(__ -> newConstructors);
    }

    public static Function<DataConstruction, DataConstruction> modConstructors(Function<MultipleConstructors, MultipleConstructors> constructorsMod) {
        DataConstruction.Cases<DataConstruction> cases = DataConstructions.cases(constructors -> DataConstructions.multipleConstructors((MultipleConstructors)constructorsMod.apply((MultipleConstructors)constructors)), DataConstructions::oneConstructor, DataConstructions::noConstructor);
        return dataConstruction -> (DataConstruction)dataConstruction.match(cases);
    }

    public static Function<DataConstruction, DataConstruction> setConstructor(DataConstructor newConstructor) {
        return DataConstructions.modConstructor(__ -> newConstructor);
    }

    public static Function<DataConstruction, DataConstruction> modConstructor(Function<DataConstructor, DataConstructor> constructorMod) {
        DataConstruction.Cases<DataConstruction> cases = DataConstructions.cases(DataConstructions::multipleConstructors, constructor -> DataConstructions.oneConstructor((DataConstructor)constructorMod.apply((DataConstructor)constructor)), DataConstructions::noConstructor);
        return dataConstruction -> (DataConstruction)dataConstruction.match(cases);
    }

    static {
        constructorsGetter = DataConstructions.cases(constructors -> Optional.of(constructors), constructor -> Optional.empty(), () -> Optional.empty());
        constructorGetter = DataConstructions.cases(constructors -> Optional.empty(), constructor -> Optional.of(constructor), () -> Optional.empty());
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<R> {
            private final DataConstruction _dataConstruction;
            private final Function<MultipleConstructors, R> multipleConstructors;
            private final Function<DataConstructor, R> oneConstructor;
            private final Supplier<R> noConstructor;

            PartialMatcher(DataConstruction _dataConstruction, Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor, Supplier<R> noConstructor) {
                this._dataConstruction = _dataConstruction;
                this.multipleConstructors = multipleConstructors;
                this.oneConstructor = oneConstructor;
                this.noConstructor = noConstructor;
            }

            public final R otherwise(Supplier<R> otherwise) {
                DataConstruction.Cases<R> cases = DataConstructions.cases(this.multipleConstructors != null ? this.multipleConstructors : constructors -> otherwise.get(), this.oneConstructor != null ? this.oneConstructor : constructor -> otherwise.get(), this.noConstructor != null ? this.noConstructor : () -> otherwise.get());
                return this._dataConstruction.match(cases);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                DataConstruction.Cases<Optional> cases = DataConstructions.cases(this.multipleConstructors != null ? constructors -> Optional.of(this.multipleConstructors.apply((MultipleConstructors)constructors)) : constructors -> Optional.empty(), this.oneConstructor != null ? constructor -> Optional.of(this.oneConstructor.apply((DataConstructor)constructor)) : constructor -> Optional.empty(), this.noConstructor != null ? () -> Optional.of(this.noConstructor.get()) : () -> Optional.empty());
                return this._dataConstruction.match(cases);
            }
        }

        public static class PartialMatcher_NoConstructor<R>
        extends PartialMatcher<R> {
            PartialMatcher_NoConstructor(DataConstruction _dataConstruction, Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor) {
                super(_dataConstruction, multipleConstructors, oneConstructor, null);
            }

            public final PartialMatcher<R> noConstructor(Supplier<R> noConstructor) {
                return new PartialMatcher<R>(((PartialMatcher)this)._dataConstruction, ((PartialMatcher)this).multipleConstructors, ((PartialMatcher)this).oneConstructor, noConstructor);
            }

            public final PartialMatcher<R> noConstructor_(R r) {
                return this.noConstructor(() -> r);
            }
        }

        public static final class TotalMatcher_NoConstructor<R>
        extends PartialMatcher<R> {
            TotalMatcher_NoConstructor(DataConstruction _dataConstruction, Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor) {
                super(_dataConstruction, multipleConstructors, oneConstructor, null);
            }

            public final R noConstructor(Supplier<R> noConstructor) {
                DataConstruction.Cases<R> cases = DataConstructions.cases(((PartialMatcher)this).multipleConstructors, ((PartialMatcher)this).oneConstructor, noConstructor);
                return ((PartialMatcher)this)._dataConstruction.match(cases);
            }

            public final R noConstructor_(R r) {
                return (R)this.noConstructor(() -> r);
            }
        }

        public static final class TotalMatcher_OneConstructor<R>
        extends PartialMatcher_NoConstructor<R> {
            TotalMatcher_OneConstructor(DataConstruction _dataConstruction, Function<MultipleConstructors, R> multipleConstructors) {
                super(_dataConstruction, multipleConstructors, null);
            }

            public final TotalMatcher_NoConstructor<R> oneConstructor(Function<DataConstructor, R> oneConstructor) {
                return new TotalMatcher_NoConstructor<R>(((PartialMatcher)this)._dataConstruction, ((PartialMatcher)this).multipleConstructors, oneConstructor);
            }

            public final TotalMatcher_NoConstructor<R> oneConstructor_(R r) {
                return this.oneConstructor(constructor -> r);
            }
        }

        public static final class TotalMatcher_MultipleConstructors {
            private final DataConstruction _dataConstruction;

            TotalMatcher_MultipleConstructors(DataConstruction _dataConstruction) {
                this._dataConstruction = _dataConstruction;
            }

            public final <R> TotalMatcher_OneConstructor<R> multipleConstructors(Function<MultipleConstructors, R> multipleConstructors) {
                return new TotalMatcher_OneConstructor<R>(this._dataConstruction, multipleConstructors);
            }

            public final <R> TotalMatcher_OneConstructor<R> multipleConstructors_(R r) {
                return this.multipleConstructors(constructors -> r);
            }

            public final <R> PartialMatcher_NoConstructor<R> oneConstructor(Function<DataConstructor, R> oneConstructor) {
                return new PartialMatcher_NoConstructor<R>(this._dataConstruction, null, oneConstructor);
            }

            public final <R> PartialMatcher_NoConstructor<R> oneConstructor_(R r) {
                return this.oneConstructor(constructor -> r);
            }

            public final <R> PartialMatcher<R> noConstructor(Supplier<R> noConstructor) {
                return new PartialMatcher<R>(this._dataConstruction, null, null, noConstructor);
            }

            public final <R> PartialMatcher<R> noConstructor_(R r) {
                return this.noConstructor(() -> r);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_MultipleConstructors totalMatcher_MultipleConstructors = new TotalMatcher_MultipleConstructors();

        private CasesMatchers() {
        }

        public static class PartialMatcher<R> {
            private final Function<MultipleConstructors, R> multipleConstructors;
            private final Function<DataConstructor, R> oneConstructor;
            private final Supplier<R> noConstructor;

            PartialMatcher(Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor, Supplier<R> noConstructor) {
                this.multipleConstructors = multipleConstructors;
                this.oneConstructor = oneConstructor;
                this.noConstructor = noConstructor;
            }

            public final Function<DataConstruction, R> otherwise(Supplier<R> otherwise) {
                DataConstruction.Cases cases = DataConstructions.cases(this.multipleConstructors != null ? this.multipleConstructors : constructors -> otherwise.get(), this.oneConstructor != null ? this.oneConstructor : constructor -> otherwise.get(), this.noConstructor != null ? this.noConstructor : () -> otherwise.get());
                return dataConstruction -> dataConstruction.match(cases);
            }

            public final Function<DataConstruction, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<DataConstruction, Optional<R>> otherwiseEmpty() {
                DataConstruction.Cases<Optional> cases = DataConstructions.cases(this.multipleConstructors != null ? constructors -> Optional.of(this.multipleConstructors.apply((MultipleConstructors)constructors)) : constructors -> Optional.empty(), this.oneConstructor != null ? constructor -> Optional.of(this.oneConstructor.apply((DataConstructor)constructor)) : constructor -> Optional.empty(), this.noConstructor != null ? () -> Optional.of(this.noConstructor.get()) : () -> Optional.empty());
                return dataConstruction -> (Optional)dataConstruction.match(cases);
            }
        }

        public static class PartialMatcher_NoConstructor<R>
        extends PartialMatcher<R> {
            PartialMatcher_NoConstructor(Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor) {
                super(multipleConstructors, oneConstructor, null);
            }

            public final PartialMatcher<R> noConstructor(Supplier<R> noConstructor) {
                return new PartialMatcher<R>(((PartialMatcher)this).multipleConstructors, ((PartialMatcher)this).oneConstructor, noConstructor);
            }

            public final PartialMatcher<R> noConstructor_(R r) {
                return this.noConstructor(() -> r);
            }
        }

        public static final class TotalMatcher_NoConstructor<R>
        extends PartialMatcher<R> {
            TotalMatcher_NoConstructor(Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor) {
                super(multipleConstructors, oneConstructor, null);
            }

            public final Function<DataConstruction, R> noConstructor(Supplier<R> noConstructor) {
                DataConstruction.Cases cases = DataConstructions.cases(((PartialMatcher)this).multipleConstructors, ((PartialMatcher)this).oneConstructor, noConstructor);
                return dataConstruction -> dataConstruction.match(cases);
            }

            public final Function<DataConstruction, R> noConstructor_(R r) {
                return this.noConstructor(() -> r);
            }
        }

        public static final class TotalMatcher_OneConstructor<R>
        extends PartialMatcher_NoConstructor<R> {
            TotalMatcher_OneConstructor(Function<MultipleConstructors, R> multipleConstructors) {
                super(multipleConstructors, null);
            }

            public final TotalMatcher_NoConstructor<R> oneConstructor(Function<DataConstructor, R> oneConstructor) {
                return new TotalMatcher_NoConstructor<R>(((PartialMatcher)this).multipleConstructors, oneConstructor);
            }

            public final TotalMatcher_NoConstructor<R> oneConstructor_(R r) {
                return this.oneConstructor(constructor -> r);
            }
        }

        public static final class TotalMatcher_MultipleConstructors {
            TotalMatcher_MultipleConstructors() {
            }

            public final <R> TotalMatcher_OneConstructor<R> multipleConstructors(Function<MultipleConstructors, R> multipleConstructors) {
                return new TotalMatcher_OneConstructor<R>(multipleConstructors);
            }

            public final <R> TotalMatcher_OneConstructor<R> multipleConstructors_(R r) {
                return this.multipleConstructors(constructors -> r);
            }

            public final <R> PartialMatcher_NoConstructor<R> oneConstructor(Function<DataConstructor, R> oneConstructor) {
                return new PartialMatcher_NoConstructor<R>(null, oneConstructor);
            }

            public final <R> PartialMatcher_NoConstructor<R> oneConstructor_(R r) {
                return this.oneConstructor(constructor -> r);
            }

            public final <R> PartialMatcher<R> noConstructor(Supplier<R> noConstructor) {
                return new PartialMatcher<R>(null, null, noConstructor);
            }

            public final <R> PartialMatcher<R> noConstructor_(R r) {
                return this.noConstructor(() -> r);
            }
        }
    }

    private static final class Lazy
    extends DataConstruction {
        private volatile Supplier<DataConstruction> expression;
        private DataConstruction evaluation;

        Lazy(Supplier<DataConstruction> dataConstruction) {
            this.expression = dataConstruction;
        }

        private synchronized DataConstruction _evaluate() {
            block2: {
                DataConstruction eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DataConstruction> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(DataConstruction.Cases<R> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }
    }

    private static final class NoConstructor
    extends DataConstruction {
        NoConstructor() {
        }

        @Override
        public <R> R match(DataConstruction.Cases<R> cases) {
            return cases.noConstructor();
        }
    }

    private static final class OneConstructor
    extends DataConstruction {
        private final DataConstructor constructor;

        OneConstructor(DataConstructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public <R> R match(DataConstruction.Cases<R> cases) {
            return cases.oneConstructor(this.constructor);
        }
    }

    private static final class MultipleConstructors_
    extends DataConstruction {
        private final MultipleConstructors constructors;

        MultipleConstructors_(MultipleConstructors constructors) {
            this.constructors = constructors;
        }

        @Override
        public <R> R match(DataConstruction.Cases<R> cases) {
            return cases.multipleConstructors(this.constructors);
        }
    }

    private static final class LambdaCases<R>
    implements DataConstruction.Cases<R> {
        private final Function<MultipleConstructors, R> multipleConstructors;
        private final Function<DataConstructor, R> oneConstructor;
        private final Supplier<R> noConstructor;

        LambdaCases(Function<MultipleConstructors, R> multipleConstructors, Function<DataConstructor, R> oneConstructor, Supplier<R> noConstructor) {
            this.multipleConstructors = multipleConstructors;
            this.oneConstructor = oneConstructor;
            this.noConstructor = noConstructor;
        }

        @Override
        public R multipleConstructors(MultipleConstructors constructors) {
            return this.multipleConstructors.apply(constructors);
        }

        @Override
        public R oneConstructor(DataConstructor constructor) {
            return this.oneConstructor.apply(constructor);
        }

        @Override
        public R noConstructor() {
            return this.noConstructor.get();
        }
    }
}

