/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import com.squareup.javapoet.ClassName;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.ArgOption;
import org.derive4j.Flavour;
import org.derive4j.Make;
import org.derive4j.processor.api.model.DeriveConfig;
import org.derive4j.processor.api.model.DeriveTargetClass;
import org.derive4j.processor.api.model.DerivedInstanceConfig;

public final class DeriveConfigs {
    private DeriveConfigs() {
    }

    public static DeriveConfig Config(Flavour flavour, DeriveTargetClass targetClass, Set<Make> makes, Set<ArgOption> argOptions, Map<ClassName, DerivedInstanceConfig> derivedInstances) {
        return new Config(flavour, targetClass, makes, argOptions, derivedInstances);
    }

    public static DeriveConfig lazy(Supplier<DeriveConfig> deriveConfig) {
        return new Lazy(deriveConfig);
    }

    public static CasesMatchers.TotalMatcher_Config cases() {
        return CasesMatchers.totalMatcher_Config;
    }

    public static Flavour getFlavour(DeriveConfig deriveConfig) {
        return deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> flavour);
    }

    public static DeriveTargetClass getTargetClass(DeriveConfig deriveConfig) {
        return deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> targetClass);
    }

    public static Set<Make> getMakes(DeriveConfig deriveConfig) {
        return deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> makes);
    }

    public static Set<ArgOption> getArgOptions(DeriveConfig deriveConfig) {
        return deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> argOptions);
    }

    public static Map<ClassName, DerivedInstanceConfig> getDerivedInstances(DeriveConfig deriveConfig) {
        return deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> derivedInstances);
    }

    public static Function<DeriveConfig, DeriveConfig> setFlavour(Flavour newFlavour) {
        return DeriveConfigs.modFlavour(__ -> newFlavour);
    }

    public static Function<DeriveConfig, DeriveConfig> modFlavour(Function<Flavour, Flavour> flavourMod) {
        return deriveConfig -> deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> DeriveConfigs.Config((Flavour)flavourMod.apply(flavour), targetClass, makes, argOptions, derivedInstances));
    }

    public static Function<DeriveConfig, DeriveConfig> setTargetClass(DeriveTargetClass newTargetClass) {
        return DeriveConfigs.modTargetClass(__ -> newTargetClass);
    }

    public static Function<DeriveConfig, DeriveConfig> modTargetClass(Function<DeriveTargetClass, DeriveTargetClass> targetClassMod) {
        return deriveConfig -> deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> DeriveConfigs.Config(flavour, (DeriveTargetClass)targetClassMod.apply(targetClass), makes, argOptions, derivedInstances));
    }

    public static Function<DeriveConfig, DeriveConfig> setMakes(Set<Make> newMakes) {
        return DeriveConfigs.modMakes(__ -> newMakes);
    }

    public static Function<DeriveConfig, DeriveConfig> modMakes(Function<Set<Make>, Set<Make>> makesMod) {
        return deriveConfig -> deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> DeriveConfigs.Config(flavour, targetClass, (Set)makesMod.apply(makes), argOptions, derivedInstances));
    }

    public static Function<DeriveConfig, DeriveConfig> setArgOptions(Set<ArgOption> newArgOptions) {
        return DeriveConfigs.modArgOptions(__ -> newArgOptions);
    }

    public static Function<DeriveConfig, DeriveConfig> modArgOptions(Function<Set<ArgOption>, Set<ArgOption>> argOptionsMod) {
        return deriveConfig -> deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> DeriveConfigs.Config(flavour, targetClass, makes, (Set)argOptionsMod.apply(argOptions), derivedInstances));
    }

    public static Function<DeriveConfig, DeriveConfig> setDerivedInstances(Map<ClassName, DerivedInstanceConfig> newDerivedInstances) {
        return DeriveConfigs.modDerivedInstances(__ -> newDerivedInstances);
    }

    public static Function<DeriveConfig, DeriveConfig> modDerivedInstances(Function<Map<ClassName, DerivedInstanceConfig>, Map<ClassName, DerivedInstanceConfig>> derivedInstancesMod) {
        return deriveConfig -> deriveConfig.match((flavour, targetClass, makes, argOptions, derivedInstances) -> DeriveConfigs.Config(flavour, targetClass, makes, argOptions, (Map)derivedInstancesMod.apply(derivedInstances)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Config totalMatcher_Config = new TotalMatcher_Config();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Config {
            TotalMatcher_Config() {
            }

            public final <X> Function<DeriveConfig, X> Config(DeriveConfig.Case<X> Config2) {
                return deriveConfig -> deriveConfig.match(Config2);
            }

            public final <X> Function<DeriveConfig, X> Config_(X x) {
                return this.Config((flavour, targetClass, makes, argOptions, derivedInstances) -> x);
            }
        }
    }

    private static final class Lazy
    extends DeriveConfig {
        private volatile Supplier<DeriveConfig> expression;
        private DeriveConfig evaluation;

        Lazy(Supplier<DeriveConfig> deriveConfig) {
            this.expression = deriveConfig;
        }

        private synchronized DeriveConfig _evaluate() {
            block2: {
                DeriveConfig eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<DeriveConfig> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(DeriveConfig.Case<X> Case2) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(Case2);
        }
    }

    private static final class Config
    extends DeriveConfig {
        private final Flavour flavour;
        private final DeriveTargetClass targetClass;
        private final Set<Make> makes;
        private final Set<ArgOption> argOptions;
        private final Map<ClassName, DerivedInstanceConfig> derivedInstances;

        Config(Flavour flavour, DeriveTargetClass targetClass, Set<Make> makes, Set<ArgOption> argOptions, Map<ClassName, DerivedInstanceConfig> derivedInstances) {
            this.flavour = flavour;
            this.targetClass = targetClass;
            this.makes = makes;
            this.argOptions = argOptions;
            this.derivedInstances = derivedInstances;
        }

        @Override
        public <X> X match(DeriveConfig.Case<X> Case2) {
            return Case2.Config(this.flavour, this.targetClass, this.makes, this.argOptions, this.derivedInstances);
        }
    }
}

