/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.derive4j.processor.api.model.Expression;

public final class Expressions {
    private static final Expression.Cases<Optional<CodeBlock>> codeBlockGetter = Expressions.cases(codeBlock -> Optional.of(codeBlock), fromOuterMethod -> Optional.empty());
    private static final Expression.Cases<Optional<UnaryOperator<CodeBlock>>> fromOuterMethodGetter = Expressions.cases(codeBlock -> Optional.empty(), fromOuterMethod -> Optional.of(fromOuterMethod));

    private Expressions() {
    }

    public static <X> Expression.Cases<X> cases(Function<CodeBlock, X> baseExpression, Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
        return new LambdaCases<X>(baseExpression, recursiveExpression);
    }

    public static Expression baseExpression(CodeBlock codeBlock) {
        return new BaseExpression(codeBlock);
    }

    public static Expression recursiveExpression(UnaryOperator<CodeBlock> fromOuterMethod) {
        return new RecursiveExpression(fromOuterMethod);
    }

    public static Expression lazy(Supplier<Expression> expression) {
        return new Lazy(expression);
    }

    public static CasesMatchers.TotalMatcher_BaseExpression cases() {
        return CasesMatchers.totalMatcher_BaseExpression;
    }

    public static CaseOfMatchers.TotalMatcher_BaseExpression caseOf(Expression expression) {
        return new CaseOfMatchers.TotalMatcher_BaseExpression(expression);
    }

    public static Optional<CodeBlock> getCodeBlock(Expression expression) {
        return expression.match(codeBlockGetter);
    }

    public static Optional<UnaryOperator<CodeBlock>> getFromOuterMethod(Expression expression) {
        return expression.match(fromOuterMethodGetter);
    }

    public static Function<Expression, Expression> setCodeBlock(CodeBlock newCodeBlock) {
        return Expressions.modCodeBlock(__ -> newCodeBlock);
    }

    public static Function<Expression, Expression> modCodeBlock(Function<CodeBlock, CodeBlock> codeBlockMod) {
        Expression.Cases<Expression> cases = Expressions.cases(codeBlock -> Expressions.baseExpression((CodeBlock)codeBlockMod.apply((CodeBlock)codeBlock)), Expressions::recursiveExpression);
        return expression -> (Expression)expression.match(cases);
    }

    public static Function<Expression, Expression> setFromOuterMethod(UnaryOperator<CodeBlock> newFromOuterMethod) {
        return Expressions.modFromOuterMethod(__ -> newFromOuterMethod);
    }

    public static Function<Expression, Expression> modFromOuterMethod(Function<UnaryOperator<CodeBlock>, UnaryOperator<CodeBlock>> fromOuterMethodMod) {
        Expression.Cases<Expression> cases = Expressions.cases(Expressions::baseExpression, fromOuterMethod -> Expressions.recursiveExpression((UnaryOperator)fromOuterMethodMod.apply((UnaryOperator<CodeBlock>)fromOuterMethod)));
        return expression -> (Expression)expression.match(cases);
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<X> {
            private final Expression _expression;
            private final Function<CodeBlock, X> baseExpression;
            private final Function<UnaryOperator<CodeBlock>, X> recursiveExpression;

            PartialMatcher(Expression _expression, Function<CodeBlock, X> baseExpression, Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                this._expression = _expression;
                this.baseExpression = baseExpression;
                this.recursiveExpression = recursiveExpression;
            }

            public final X otherwise(Supplier<X> otherwise) {
                Expression.Cases<X> cases = Expressions.cases(this.baseExpression != null ? this.baseExpression : codeBlock -> otherwise.get(), this.recursiveExpression != null ? this.recursiveExpression : fromOuterMethod -> otherwise.get());
                return this._expression.match(cases);
            }

            public final X otherwise_(X x) {
                return (X)this.otherwise(() -> x);
            }

            public final Optional<X> otherwiseEmpty() {
                Expression.Cases<Optional> cases = Expressions.cases(this.baseExpression != null ? codeBlock -> Optional.of(this.baseExpression.apply((CodeBlock)codeBlock)) : codeBlock -> Optional.empty(), this.recursiveExpression != null ? fromOuterMethod -> Optional.of(this.recursiveExpression.apply((UnaryOperator<CodeBlock>)fromOuterMethod)) : fromOuterMethod -> Optional.empty());
                return this._expression.match(cases);
            }
        }

        public static final class TotalMatcher_RecursiveExpression<X>
        extends PartialMatcher<X> {
            TotalMatcher_RecursiveExpression(Expression _expression, Function<CodeBlock, X> baseExpression) {
                super(_expression, baseExpression, null);
            }

            public final X recursiveExpression(Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                Expression.Cases<X> cases = Expressions.cases(((PartialMatcher)this).baseExpression, recursiveExpression);
                return ((PartialMatcher)this)._expression.match(cases);
            }

            public final X recursiveExpression_(X x) {
                return (X)this.recursiveExpression(fromOuterMethod -> x);
            }
        }

        public static final class TotalMatcher_BaseExpression {
            private final Expression _expression;

            TotalMatcher_BaseExpression(Expression _expression) {
                this._expression = _expression;
            }

            public final <X> TotalMatcher_RecursiveExpression<X> baseExpression(Function<CodeBlock, X> baseExpression) {
                return new TotalMatcher_RecursiveExpression<X>(this._expression, baseExpression);
            }

            public final <X> TotalMatcher_RecursiveExpression<X> baseExpression_(X x) {
                return this.baseExpression(codeBlock -> x);
            }

            public final <X> PartialMatcher<X> recursiveExpression(Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                return new PartialMatcher<X>(this._expression, null, recursiveExpression);
            }

            public final <X> PartialMatcher<X> recursiveExpression_(X x) {
                return this.recursiveExpression(fromOuterMethod -> x);
            }
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_BaseExpression totalMatcher_BaseExpression = new TotalMatcher_BaseExpression();

        private CasesMatchers() {
        }

        public static class PartialMatcher<X> {
            private final Function<CodeBlock, X> baseExpression;
            private final Function<UnaryOperator<CodeBlock>, X> recursiveExpression;

            PartialMatcher(Function<CodeBlock, X> baseExpression, Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                this.baseExpression = baseExpression;
                this.recursiveExpression = recursiveExpression;
            }

            public final Function<Expression, X> otherwise(Supplier<X> otherwise) {
                Expression.Cases cases = Expressions.cases(this.baseExpression != null ? this.baseExpression : codeBlock -> otherwise.get(), this.recursiveExpression != null ? this.recursiveExpression : fromOuterMethod -> otherwise.get());
                return expression -> expression.match(cases);
            }

            public final Function<Expression, X> otherwise_(X x) {
                return this.otherwise(() -> x);
            }

            public final Function<Expression, Optional<X>> otherwiseEmpty() {
                Expression.Cases<Optional> cases = Expressions.cases(this.baseExpression != null ? codeBlock -> Optional.of(this.baseExpression.apply((CodeBlock)codeBlock)) : codeBlock -> Optional.empty(), this.recursiveExpression != null ? fromOuterMethod -> Optional.of(this.recursiveExpression.apply((UnaryOperator<CodeBlock>)fromOuterMethod)) : fromOuterMethod -> Optional.empty());
                return expression -> (Optional)expression.match(cases);
            }
        }

        public static final class TotalMatcher_RecursiveExpression<X>
        extends PartialMatcher<X> {
            TotalMatcher_RecursiveExpression(Function<CodeBlock, X> baseExpression) {
                super(baseExpression, null);
            }

            public final Function<Expression, X> recursiveExpression(Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                Expression.Cases cases = Expressions.cases(((PartialMatcher)this).baseExpression, recursiveExpression);
                return expression -> expression.match(cases);
            }

            public final Function<Expression, X> recursiveExpression_(X x) {
                return this.recursiveExpression(fromOuterMethod -> x);
            }
        }

        public static final class TotalMatcher_BaseExpression {
            TotalMatcher_BaseExpression() {
            }

            public final <X> TotalMatcher_RecursiveExpression<X> baseExpression(Function<CodeBlock, X> baseExpression) {
                return new TotalMatcher_RecursiveExpression<X>(baseExpression);
            }

            public final <X> TotalMatcher_RecursiveExpression<X> baseExpression_(X x) {
                return this.baseExpression(codeBlock -> x);
            }

            public final <X> PartialMatcher<X> recursiveExpression(Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
                return new PartialMatcher<X>(null, recursiveExpression);
            }

            public final <X> PartialMatcher<X> recursiveExpression_(X x) {
                return this.recursiveExpression(fromOuterMethod -> x);
            }
        }
    }

    private static final class Lazy
    extends Expression {
        private volatile Supplier<Expression> expression;
        private Expression evaluation;

        Lazy(Supplier<Expression> expression) {
            this.expression = expression;
        }

        private synchronized Expression _evaluate() {
            block2: {
                Expression eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<Expression> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <X> X match(Expression.Cases<X> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }
    }

    private static final class RecursiveExpression
    extends Expression {
        private final UnaryOperator<CodeBlock> fromOuterMethod;

        RecursiveExpression(UnaryOperator<CodeBlock> fromOuterMethod) {
            this.fromOuterMethod = fromOuterMethod;
        }

        @Override
        public <X> X match(Expression.Cases<X> cases) {
            return cases.recursiveExpression(this.fromOuterMethod);
        }
    }

    private static final class BaseExpression
    extends Expression {
        private final CodeBlock codeBlock;

        BaseExpression(CodeBlock codeBlock) {
            this.codeBlock = codeBlock;
        }

        @Override
        public <X> X match(Expression.Cases<X> cases) {
            return cases.baseExpression(this.codeBlock);
        }
    }

    private static final class LambdaCases<X>
    implements Expression.Cases<X> {
        private final Function<CodeBlock, X> baseExpression;
        private final Function<UnaryOperator<CodeBlock>, X> recursiveExpression;

        LambdaCases(Function<CodeBlock, X> baseExpression, Function<UnaryOperator<CodeBlock>, X> recursiveExpression) {
            this.baseExpression = baseExpression;
            this.recursiveExpression = recursiveExpression;
        }

        @Override
        public X baseExpression(CodeBlock codeBlock) {
            return this.baseExpression.apply(codeBlock);
        }

        @Override
        public X recursiveExpression(UnaryOperator<CodeBlock> fromOuterMethod) {
            return this.recursiveExpression.apply(fromOuterMethod);
        }
    }
}

