/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.api.model;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeVariable;
import org.derive4j.processor.api.model.MatchMethod;

public final class MatchMethods {
    private MatchMethods() {
    }

    public static MatchMethod matchMethod(ExecutableElement element, TypeVariable returnTypeVariable) {
        return new MatchMethod_(element, returnTypeVariable);
    }

    public static MatchMethod lazy(Supplier<MatchMethod> matchMethod) {
        return new Lazy(matchMethod);
    }

    public static CasesMatchers.TotalMatcher_MatchMethod cases() {
        return CasesMatchers.totalMatcher_MatchMethod;
    }

    public static ExecutableElement getElement(MatchMethod matchMethod) {
        return matchMethod.match((element, returnTypeVariable) -> element);
    }

    public static TypeVariable getReturnTypeVariable(MatchMethod matchMethod) {
        return matchMethod.match((element, returnTypeVariable) -> returnTypeVariable);
    }

    public static Function<MatchMethod, MatchMethod> setElement(ExecutableElement newElement) {
        return MatchMethods.modElement(__ -> newElement);
    }

    public static Function<MatchMethod, MatchMethod> modElement(Function<ExecutableElement, ExecutableElement> elementMod) {
        return matchMethod -> matchMethod.match((element, returnTypeVariable) -> MatchMethods.matchMethod((ExecutableElement)elementMod.apply(element), returnTypeVariable));
    }

    public static Function<MatchMethod, MatchMethod> setReturnTypeVariable(TypeVariable newReturnTypeVariable) {
        return MatchMethods.modReturnTypeVariable(__ -> newReturnTypeVariable);
    }

    public static Function<MatchMethod, MatchMethod> modReturnTypeVariable(Function<TypeVariable, TypeVariable> returnTypeVariableMod) {
        return matchMethod -> matchMethod.match((element, returnTypeVariable) -> MatchMethods.matchMethod(element, (TypeVariable)returnTypeVariableMod.apply(returnTypeVariable)));
    }

    public static class CasesMatchers {
        private static final TotalMatcher_MatchMethod totalMatcher_MatchMethod = new TotalMatcher_MatchMethod();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_MatchMethod {
            TotalMatcher_MatchMethod() {
            }

            public final <R> Function<MatchMethod, R> matchMethod(MatchMethod.Case<R> matchMethod) {
                return matchMethod_ -> matchMethod_.match(matchMethod);
            }

            public final <R> Function<MatchMethod, R> matchMethod_(R r) {
                return this.matchMethod((element, returnTypeVariable) -> r);
            }
        }
    }

    private static final class Lazy
    extends MatchMethod {
        private volatile Supplier<MatchMethod> expression;
        private MatchMethod evaluation;

        Lazy(Supplier<MatchMethod> matchMethod) {
            this.expression = matchMethod;
        }

        private synchronized MatchMethod _evaluate() {
            block2: {
                MatchMethod eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<MatchMethod> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(MatchMethod.Case<R> matchMethod) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(matchMethod);
        }
    }

    private static final class MatchMethod_
    extends MatchMethod {
        private final ExecutableElement element;
        private final TypeVariable returnTypeVariable;

        MatchMethod_(ExecutableElement element, TypeVariable returnTypeVariable) {
            this.element = element;
            this.returnTypeVariable = returnTypeVariable;
        }

        @Override
        public <R> R match(MatchMethod.Case<R> matchMethod) {
            return matchMethod.matchMethod(this.element, this.returnTypeVariable);
        }
    }
}

