/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.text.Bidi;
import org.docx4j.convert.in.xhtml.ImportXHTMLProperties;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BidiTest {
    private WordprocessingMLPackage wordMLPackage;
    private XHTMLImporterImpl XHTMLImporter;
    private static final String MIXED_HEBREW = "\u05dc\u05d9\u05e6\u05d5\u05e8 \u05de\u05d4\u05e8\u05e9\u05ea \u05e8\u05e9\u05eathe cat\u05db\u05dc\u05dc 123\u05e2\u05d5\u05dc\u05de\u05d9\u05ea \u05d1\u05d0\u05de\u05ea!";

    @Before
    public void setup() throws InvalidFormatException {
        ImportXHTMLProperties.setProperty("docx4j-ImportXHTML.Bidi.Heuristic", true);
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
        this.XHTMLImporter = new XHTMLImporterImpl(this.wordMLPackage);
    }

    @Test
    public void testMixed() {
        Assert.assertTrue((boolean)this.XHTMLImporter.isBidi(MIXED_HEBREW));
    }

    @Test
    public void testLTR() {
        Assert.assertFalse((boolean)this.XHTMLImporter.isBidi("this is just left to right"));
    }

    @Test
    public void testRun0_LTR() {
        Bidi bidi = new Bidi("this is just left to right", 0);
        Assert.assertTrue((boolean)this.nthRunIsLeftToRight(bidi, 0));
    }

    @Test
    public void testMixedHebrewRun0_RTL() {
        Bidi bidi = new Bidi(MIXED_HEBREW, 1);
        Assert.assertFalse((boolean)this.nthRunIsLeftToRight(bidi, 0));
    }

    @Test
    public void testMixedHebrewRun1_RTL() {
        Bidi bidi = new Bidi(MIXED_HEBREW, 1);
        Assert.assertTrue((boolean)this.nthRunIsLeftToRight(bidi, 1));
    }

    private boolean nthRunIsLeftToRight(Bidi bidi, int n) {
        return this.isEven(bidi.getRunLevel(n));
    }

    private boolean isEven(int x) {
        return (x & 1) == 0;
    }
}

