/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.List;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageAddTest {
    private final String GIF_IMAGE_DATA = "data:image/gif;base64,R0lGODdhAgACAKEEAAMA//8AAAD/Bv/8ACwAAAAAAgACAAACAww0BQA7";
    private final String PNG_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC";
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws Exception {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    @Test
    public void testSizeUnspecified() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC'/></div>");
        if (UnitsOfMeasurement.DPI == 96) {
            Assert.assertTrue((inline1.getExtent().getCx() == 19050L ? 1 : 0) != 0);
        } else if (UnitsOfMeasurement.DPI == 72) {
            Assert.assertTrue((inline1.getExtent().getCx() == 25400L ? 1 : 0) != 0);
        } else {
            System.out.println("Skipping test for DPI " + UnitsOfMeasurement.DPI);
        }
    }

    @Test
    public void testSize20px() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='20px' height='20px' /></div>");
        Assert.assertTrue((inline1.getExtent().getCx() == 338667L ? 1 : 0) != 0);
    }

    @Test
    public void testSize20NoUnits() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='20' height='20' /></div>");
        Assert.assertTrue((inline1.getExtent().getCx() == 338667L ? 1 : 0) != 0);
    }

    @Test
    public void testSize20pt() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='20pt' height='20pt' /></div>");
        Assert.assertTrue((inline1.getExtent().getCx() == 451273L ? 1 : 0) != 0);
    }

    @Test
    public void testSizeNoHeight() throws Exception {
        Inline inline = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='20pt'  /></div>");
        Assert.assertTrue((Math.round(inline.getExtent().getCx() / 10L) == Math.round(inline.getExtent().getCy() / 10L) ? 1 : 0) != 0);
    }

    @Test
    public void testSizeNoWidth() throws Exception {
        Inline inline = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='20pt'  /></div>");
        Assert.assertTrue((Math.round(inline.getExtent().getCx() / 10L) == Math.round(inline.getExtent().getCy() / 10L) ? 1 : 0) != 0);
    }

    @Test
    public void testSizeSpecifiedPxPlusCSS() throws Exception {
        Inline inline2 = this.getInline("<div><img style='padding-top:10px;padding-left:10px;' src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='20px' height='10px' /></div>");
        Assert.assertTrue((inline2.getExtent().getCx() == 338667L ? 1 : 0) != 0);
    }

    private Inline getInline(String html) throws Exception {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        List<Object> convert = XHTMLImporter2.convert(html, null);
        return (Inline)((Drawing)((R)((P)convert.get(0)).getContent().get(0)).getContent().get(0)).getAnchorOrInline().get(0);
    }
}

