/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.math.BigInteger;
import java.util.List;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCellMergeTest {
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws InvalidFormatException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    @Test
    public void testVerticalCellMerging() throws Docx4JException {
        List<Object> tbl = this.table("<tr><td>1</td><td rowspan='2'>2</td></tr><tr><td>3</td></tr>");
        Assert.assertEquals((String)"table has two rows", (long)2L, (long)tbl.size());
        List tr1 = ((Tr)tbl.get(0)).getContent();
        List tr2 = ((Tr)tbl.get(1)).getContent();
        Assert.assertEquals((String)"two cells in each row", (long)2L, (long)tr1.size());
        Assert.assertEquals((String)"two cells in each row", (long)2L, (long)tr2.size());
        Assert.assertNull((String)"no vMerge in first column", (Object)this.vmerge(tr1, 0));
        Assert.assertNull((String)"no vMerge in first column", (Object)this.vmerge(tr2, 0));
        TcPrInner.VMerge vMerge1_2 = this.vmerge(tr1, 1);
        TcPrInner.VMerge vMerge2_2 = this.vmerge(tr2, 1);
        Assert.assertNotNull((String)"vMerge exists in second column", (Object)vMerge1_2);
        Assert.assertNotNull((String)"vMerge exists in second column", (Object)vMerge2_2);
        Assert.assertEquals((String)"vMerge val is 'restart' in first row", (Object)"restart", (Object)vMerge1_2.getVal());
        Assert.assertNull((String)"vMerge val is null in second row", (Object)vMerge2_2.getVal());
    }

    @Test
    public void testRepeatedVerticalCellMerging() throws Docx4JException {
        List<Object> tbl = this.table("<tr><td rowspan='2'>1</td><td rowspan='2'>2</td><td>3</td></tr><tr><td>4</td></tr>");
        List tr2 = ((Tr)tbl.get(1)).getContent();
        Assert.assertEquals((String)"three cells in second row", (long)3L, (long)tr2.size());
        Assert.assertNotNull((String)"vMerge exists in first column", (Object)this.vmerge(tr2, 0));
        Assert.assertNotNull((String)"vMerge exists in second column", (Object)this.vmerge(tr2, 1));
        Assert.assertNull((String)"no vMerge in third column", (Object)this.vmerge(tr2, 2));
    }

    @Test
    public void testTrailingRepeatedVerticalCellMerging() throws Docx4JException {
        List<Object> tbl = this.table("<tr><td>1</td><td rowspan='2'>2</td><td rowspan='2'>3</td></tr><tr><td>4</td></tr>");
        List tr2 = ((Tr)tbl.get(1)).getContent();
        Assert.assertEquals((String)"three cells in second row", (long)3L, (long)tr2.size());
        Assert.assertNull((String)"no vMerge in first column", (Object)this.vmerge(tr2, 0));
        Assert.assertNotNull((String)"vMerge exists in second column", (Object)this.vmerge(tr2, 1));
        Assert.assertNotNull((String)"vMerge exists in third column", (Object)this.vmerge(tr2, 2));
    }

    @Test
    public void testVerticalAndHorizontalCellMerging() throws Docx4JException {
        List<Object> tbl = this.table("<tr><td rowspan='2' colspan='2'>1</td><td>2</td></tr><tr><td>3</td></tr>");
        List tr2 = ((Tr)tbl.get(1)).getContent();
        Assert.assertEquals((String)"two cells in second row", (long)2L, (long)tr2.size());
        Assert.assertNotNull((String)"vMerge exists in first column", (Object)this.vmerge(tr2, 0));
        Assert.assertNull((String)"no vMerge in second column", (Object)this.vmerge(tr2, 1));
        TcPrInner.GridSpan gridSpan = ((Tc)tr2.get(0)).getTcPr().getGridSpan();
        Assert.assertNotNull((String)"gridSpan exists in first column", (Object)gridSpan);
        Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)gridSpan.getVal());
    }

    private List<Object> convert(String xhtml) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        return XHTMLImporter2.convert(xhtml, "");
    }

    private List<Object> table(String tableContent) throws Docx4JException {
        List<Object> converted = this.convert("<div><table>" + tableContent + "</table></div>");
        return ((Tbl)converted.get(0)).getContent();
    }

    private TcPrInner.VMerge vmerge(List<Object> row, int col) {
        return ((Tc)row.get(col)).getTcPr().getVMerge();
    }
}

