/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.math.BigInteger;
import java.util.Map;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.jaxb.Context;
import org.docx4j.org.xhtmlrenderer.css.constants.CSSName;
import org.docx4j.org.xhtmlrenderer.css.style.CssContext;
import org.docx4j.org.xhtmlrenderer.css.style.FSDerivedValue;
import org.docx4j.org.xhtmlrenderer.css.style.derived.LengthValue;
import org.docx4j.org.xhtmlrenderer.layout.Styleable;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.STBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.css.CSSValue;

public class ParagraphBorderHelper {
    public static Logger log = LoggerFactory.getLogger(ParagraphBorderHelper.class);
    private XHTMLImporterImpl importer;
    PPrBase.PBdr pBdr = null;

    protected ParagraphBorderHelper(XHTMLImporterImpl importer) {
        this.importer = importer;
    }

    private PPrBase.PBdr createPBdr(PPr pPr) {
        this.pBdr = pPr.getPBdr();
        if (this.pBdr == null) {
            this.pBdr = Context.getWmlObjectFactory().createPPrBasePBdr();
            pPr.setPBdr(this.pBdr);
        }
        return this.pBdr;
    }

    private CTBorder getBorder(PPr pPr, String side) {
        this.pBdr = this.createPBdr(pPr);
        CTBorder border = null;
        if (side.equals("left")) {
            border = this.pBdr.getLeft();
        } else if (side.equals("right")) {
            border = this.pBdr.getRight();
        } else if (side.equals("top")) {
            border = this.pBdr.getTop();
        } else if (side.equals("bottom")) {
            border = this.pBdr.getBottom();
        }
        if (border == null) {
            border = Context.getWmlObjectFactory().createCTBorder();
            if (side.equals("left")) {
                this.pBdr.setLeft(border);
            } else if (side.equals("right")) {
                this.pBdr.setRight(border);
            } else if (side.equals("top")) {
                this.pBdr.setTop(border);
            } else if (side.equals("bottom")) {
                this.pBdr.setBottom(border);
            }
        }
        return border;
    }

    private void setBorder(PPr pPr, String side, CTBorder border) {
        this.pBdr = this.createPBdr(pPr);
        if (side.equals("left")) {
            this.pBdr.setLeft(border);
        } else if (side.equals("right")) {
            this.pBdr.setRight(border);
        } else if (side.equals("top")) {
            this.pBdr.setTop(border);
        } else if (side.equals("bottom")) {
            this.pBdr.setBottom(border);
        }
    }

    protected void addBorderProperties(PPr pPr, Styleable styleable, Map<String, CSSValue> cssMap) {
        this.doSide(pPr, styleable, cssMap, "left");
        this.doSide(pPr, styleable, cssMap, "right");
        this.doSide(pPr, styleable, cssMap, "top");
        this.doSide(pPr, styleable, cssMap, "bottom");
    }

    protected void doSide(PPr pPr, Styleable styleable, Map<String, CSSValue> cssMap, String side) {
        BigInteger spaceAttrVal;
        CTBorder border = null;
        CSSValue borderStyle = cssMap.get("border-" + side + "-style");
        if (borderStyle != null && !"none".equals(borderStyle.getCssText())) {
            border = this.createBorderStyle(styleable, side);
            this.setBorder(pPr, side, border);
        }
        if ((spaceAttrVal = this.paddingToSpace(styleable, side)) != null) {
            border = this.getBorder(pPr, side);
            border.setSpace(spaceAttrVal);
        }
    }

    private BigInteger paddingToSpace(Styleable styleable, String side) {
        int twip;
        FSDerivedValue padding = styleable.getStyle().valueByName(CSSName.getByPropertyName((String)("padding-" + side)));
        if (padding != null && padding instanceof LengthValue && (twip = UnitsOfMeasurement.pxToTwip((float)(((LengthValue)padding).asFloat() / 20.0f))) > 0) {
            return BigInteger.valueOf(twip);
        }
        return null;
    }

    private CTBorder createBorderStyle(Styleable styleable, String side) {
        STBorder stBorder;
        FSDerivedValue borderStyle = styleable.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-style")));
        FSDerivedValue borderColor = styleable.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-color")));
        float width = styleable.getStyle().getFloatPropertyProportionalHeight(CSSName.getByPropertyName((String)("border-" + side + "-width")), 0.0f, (CssContext)this.importer.getRenderer().getLayoutContext());
        try {
            stBorder = STBorder.fromValue((String)borderStyle.asString());
        }
        catch (IllegalArgumentException e) {
            stBorder = STBorder.SINGLE;
        }
        width = UnitsOfMeasurement.twipToPoint((int)Math.round(width)) * 8.0f;
        String color = borderColor.asString();
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        return this.createBorderStyle(stBorder, color, BigInteger.valueOf(Math.round(width)));
    }

    private CTBorder createBorderStyle(STBorder val, String color, BigInteger sz) {
        CTBorder border = Context.getWmlObjectFactory().createCTBorder();
        border.setVal(val);
        border.setColor(color);
        border.setSz(sz);
        return border;
    }
}

