/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.docx4j.convert.in.xhtml.XHTMLImageHandler;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.org.xhtmlrenderer.docx.Docx4JFSImage;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jUserAgent;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class XHTMLImageHandlerDefault
implements XHTMLImageHandler {
    public static Logger log = LoggerFactory.getLogger(XHTMLImageHandlerDefault.class);
    private int maxWidth = -1;
    private String tableStyle;
    protected HashMap<String, BinaryPartAbstractImage> imagePartCache = new HashMap();
    private XHTMLImporterImpl importer;

    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(int maxWidth, String tableStyle) {
        this.maxWidth = maxWidth;
        this.tableStyle = tableStyle;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public XHTMLImageHandlerDefault(XHTMLImporterImpl importer) {
        this.importer = importer;
    }

    @Override
    public void addImage(Docx4jUserAgent docx4jUserAgent, WordprocessingMLPackage wordMLPackage, P p, Element e, Long cx, Long cy) {
        BinaryPartAbstractImage imagePart = null;
        boolean isError = false;
        try {
            byte[] imageBytes = null;
            if (e.getAttribute("src").startsWith("data:image")) {
                String base64String = e.getAttribute("src");
                int commaPos = base64String.indexOf(",");
                if (commaPos < 6) {
                    R run = Context.getWmlObjectFactory().createR();
                    p.getContent().add(run);
                    Text text = Context.getWmlObjectFactory().createText();
                    text.setValue("[INVALID DATA URI: " + e.getAttribute("src"));
                    run.getContent().add(text);
                    return;
                }
                base64String = base64String.substring(commaPos + 1);
                log.debug(base64String);
                imageBytes = Base64.decodeBase64((byte[])base64String.getBytes("UTF8"));
            } else {
                imagePart = this.imagePartCache.get(e.getAttribute("src"));
                if (imagePart == null) {
                    Docx4JFSImage docx4JFSImage;
                    String url = e.getAttribute("src");
                    if (url.substring(1, 2).equals(":")) {
                        url = "file:/" + url;
                    }
                    if ((docx4JFSImage = docx4jUserAgent.getDocx4JImageResource(url)) == null) {
                        log.error("Couldn't fetch " + url);
                    } else {
                        imageBytes = docx4JFSImage.getBytes();
                    }
                }
            }
            if (imageBytes == null && imagePart == null) {
                isError = true;
            } else {
                if (imagePart == null) {
                    imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, imageBytes);
                    if (!e.getAttribute("src").startsWith("data:image")) {
                        this.imagePartCache.put(e.getAttribute("src"), imagePart);
                    }
                }
                Inline inline = null;
                if (cx == null && cy == null) {
                    if (this.maxWidth > 0) {
                        log.debug("image maxWidth:" + this.maxWidth + ", table style: " + this.tableStyle);
                        System.out.println("image maxWidth:" + this.maxWidth);
                        long excessWidth = this.getTblCellMargins(this.tableStyle);
                        if (excessWidth > 0L) {
                            log.debug("table style margins subtracted (twips): " + excessWidth);
                        }
                        inline = imagePart.createImageInline(null, e.getAttribute("alt"), 0, 1, false, this.maxWidth - (int)excessWidth);
                    } else {
                        inline = imagePart.createImageInline(null, e.getAttribute("alt"), 0, 1, false);
                    }
                } else {
                    if (cx == null) {
                        cx = (long)imagePart.getImageInfo().getSize().getWidthPx() * (cy / (long)imagePart.getImageInfo().getSize().getHeightPx());
                    } else if (cy == null) {
                        cy = (long)imagePart.getImageInfo().getSize().getHeightPx() * (cx / (long)imagePart.getImageInfo().getSize().getWidthPx());
                    }
                    inline = imagePart.createImageInline(null, e.getAttribute("alt"), 0, 1, cx.longValue(), cy.longValue(), false);
                }
                R run = Context.getWmlObjectFactory().createR();
                p.getContent().add(run);
                Drawing drawing = Context.getWmlObjectFactory().createDrawing();
                run.getContent().add(drawing);
                drawing.getAnchorOrInline().add(inline);
            }
        }
        catch (Exception e1) {
            log.error(MessageFormat.format("Error during image processing: ''{0}'', insert default text.", e.getAttribute("alt")), (Throwable)e1);
            isError = true;
        }
        if (isError) {
            R run = Context.getWmlObjectFactory().createR();
            p.getContent().add(run);
            Text text = Context.getWmlObjectFactory().createText();
            text.setValue("[MISSING IMAGE: " + e.getAttribute("alt") + ", " + e.getAttribute("alt") + " ]");
            run.getContent().add(text);
        }
    }

    private long getTblCellMargins(String tableStyle) {
        Style s = null;
        if (tableStyle != null && !tableStyle.isEmpty()) {
            s = this.importer.getStyleByIdOrName(tableStyle);
        }
        if (s != null && this.importer.getTableHelper().isTableStyle(s)) {
            CTTblCellMar cellMar = this.getTblCellMar(s);
            if (cellMar == null) {
                CTTblCellMar bsCellMar = this.getBasedOnTblCellMar(s);
                if (bsCellMar != null) {
                    return this.getLeftPlusRightMarginsValue(bsCellMar);
                }
            } else {
                return this.getLeftPlusRightMarginsValue(cellMar);
            }
        }
        return 0L;
    }

    private long getLeftPlusRightMarginsValue(CTTblCellMar cellMar) {
        return cellMar.getLeft().getW().longValue() + cellMar.getRight().getW().longValue();
    }

    private CTTblCellMar getBasedOnTblCellMar(Style s) {
        Style bs;
        String basedOn;
        Style.BasedOn bo = s.getBasedOn();
        if (bo != null && (basedOn = bo.getVal()) != null && !basedOn.isEmpty() && (bs = this.importer.getStyleByIdOrName(basedOn)) != null) {
            CTTblCellMar bsCellMar = this.getTblCellMar(bs);
            if (bsCellMar != null) {
                return bsCellMar;
            }
            return this.getBasedOnTblCellMar(bs);
        }
        return null;
    }

    private CTTblCellMar getTblCellMar(Style s) {
        CTTblPrBase tpb = s.getTblPr();
        if (tpb != null) {
            return tpb.getTblCellMar();
        }
        return null;
    }
}

