/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;

public class ConvertInXHTMLDocument {
    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/sample-docx.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)ndp);
        ndp.unmarshalDefaultNumbering();
        XHTMLImporterImpl xHTMLImporter = new XHTMLImporterImpl(wordMLPackage);
        xHTMLImporter.setHyperlinkStyle("Hyperlink");
        if (inputfilepath.endsWith("html")) {
            wordMLPackage.getMainDocumentPart().getContent().addAll(xHTMLImporter.convert(new File(inputfilepath), null));
        } else if (inputfilepath.endsWith("docx")) {
            WordprocessingMLPackage docx = WordprocessingMLPackage.load((File)new File(inputfilepath));
            HtmlExporterNG2 exporter = new HtmlExporterNG2();
            FileOutputStream os = new FileOutputStream(inputfilepath + ".html");
            AbstractHtmlExporter.HtmlSettings htmlSettings = new AbstractHtmlExporter.HtmlSettings();
            htmlSettings.setImageDirPath(inputfilepath + "_files");
            htmlSettings.setImageTargetUri(inputfilepath.substring(inputfilepath.lastIndexOf("/") + 1) + "_files");
            StreamResult result = new StreamResult(os);
            exporter.html(docx, (Result)result, (HTMLSettings)htmlSettings);
            wordMLPackage.getMainDocumentPart().getContent().addAll(xHTMLImporter.convert(new File(inputfilepath + ".html"), null));
        } else {
            return;
        }
        System.out.println(XmlUtils.marshaltoString((Object)wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/html_output.docx"));
    }
}

