/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch.termination;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import org.drools.planner.core.localsearch.termination.AbstractCompositeTermination;
import org.drools.planner.core.localsearch.termination.AbstractTermination;
import org.drools.planner.core.localsearch.termination.AndCompositeTermination;
import org.drools.planner.core.localsearch.termination.OrCompositeTermination;
import org.drools.planner.core.localsearch.termination.ScoreAttainedTermination;
import org.drools.planner.core.localsearch.termination.StepCountTermination;
import org.drools.planner.core.localsearch.termination.Termination;
import org.drools.planner.core.localsearch.termination.TimeMillisSpendTermination;
import org.drools.planner.core.localsearch.termination.UnimprovedStepCountTermination;
import org.drools.planner.core.score.definition.ScoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="termination")
public class TerminationConfig {
    private Termination termination = null;
    private Class<Termination> terminationClass = null;
    private TerminationCompositionStyle terminationCompositionStyle = null;
    private Integer maximumStepCount = null;
    private Long maximumTimeMillisSpend = null;
    private Long maximumSecondsSpend = null;
    private Long maximumMinutesSpend = null;
    private Long maximumHoursSpend = null;
    private String scoreAttained = null;
    private Integer maximumUnimprovedStepCount = null;

    public Termination getTermination() {
        return this.termination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public Class<Termination> getTerminationClass() {
        return this.terminationClass;
    }

    public void setTerminationClass(Class<Termination> terminationClass) {
        this.terminationClass = terminationClass;
    }

    public TerminationCompositionStyle getTerminationCompositionStyle() {
        return this.terminationCompositionStyle;
    }

    public void setTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
    }

    public Integer getMaximumStepCount() {
        return this.maximumStepCount;
    }

    public void setMaximumStepCount(Integer maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
    }

    public Long getMaximumTimeMillisSpend() {
        return this.maximumTimeMillisSpend;
    }

    public void setMaximumTimeMillisSpend(Long maximumTimeMillisSpend) {
        this.maximumTimeMillisSpend = maximumTimeMillisSpend;
    }

    public Long getMaximumSecondsSpend() {
        return this.maximumSecondsSpend;
    }

    public void setMaximumSecondsSpend(Long maximumSecondsSpend) {
        this.maximumSecondsSpend = maximumSecondsSpend;
    }

    public Long getMaximumMinutesSpend() {
        return this.maximumMinutesSpend;
    }

    public void setMaximumMinutesSpend(Long maximumMinutesSpend) {
        this.maximumMinutesSpend = maximumMinutesSpend;
    }

    public Long getMaximumHoursSpend() {
        return this.maximumHoursSpend;
    }

    public void setMaximumHoursSpend(Long maximumHoursSpend) {
        this.maximumHoursSpend = maximumHoursSpend;
    }

    public String getScoreAttained() {
        return this.scoreAttained;
    }

    public void setScoreAttained(String scoreAttained) {
        this.scoreAttained = scoreAttained;
    }

    public Integer getMaximumUnimprovedStepCount() {
        return this.maximumUnimprovedStepCount;
    }

    public void setMaximumUnimprovedStepCount(Integer maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
    }

    public Termination buildTermination(ScoreDefinition scoreDefinition) {
        AbstractTermination termination;
        ArrayList<Termination> terminationList = new ArrayList<Termination>();
        if (this.termination != null) {
            terminationList.add(this.termination);
        }
        if (this.terminationClass != null) {
            try {
                terminationList.add(this.terminationClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("terminationClass (" + this.terminationClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("terminationClass (" + this.terminationClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        if (this.maximumStepCount != null) {
            termination = new StepCountTermination();
            ((StepCountTermination)termination).setMaximumStepCount(this.maximumStepCount);
            terminationList.add(termination);
        }
        if (this.maximumTimeMillisSpend != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(this.maximumTimeMillisSpend);
            terminationList.add(termination);
        }
        if (this.maximumSecondsSpend != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(this.maximumSecondsSpend * 1000L);
            terminationList.add(termination);
        }
        if (this.maximumMinutesSpend != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(this.maximumMinutesSpend * 60000L);
            terminationList.add(termination);
        }
        if (this.maximumHoursSpend != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(this.maximumHoursSpend * 3600000L);
            terminationList.add(termination);
        }
        if (this.scoreAttained != null) {
            termination = new ScoreAttainedTermination();
            ((ScoreAttainedTermination)termination).setScoreAttained(scoreDefinition.parseScore(this.scoreAttained));
            terminationList.add(termination);
        }
        if (this.maximumUnimprovedStepCount != null) {
            termination = new UnimprovedStepCountTermination();
            ((UnimprovedStepCountTermination)termination).setMaximumUnimprovedStepCount(this.maximumUnimprovedStepCount);
            terminationList.add(termination);
        }
        if (terminationList.size() == 1) {
            return (Termination)terminationList.get(0);
        }
        if (terminationList.size() > 1) {
            AbstractCompositeTermination compositeTermination;
            if (this.terminationCompositionStyle == null || this.terminationCompositionStyle == TerminationCompositionStyle.OR) {
                compositeTermination = new OrCompositeTermination();
            } else if (this.terminationCompositionStyle == TerminationCompositionStyle.AND) {
                compositeTermination = new AndCompositeTermination();
            } else {
                throw new IllegalStateException("The terminationCompositionStyle (" + (Object)((Object)this.terminationCompositionStyle) + ") is not implemented");
            }
            compositeTermination.setTerminationList(terminationList);
            return compositeTermination;
        }
        termination = new TimeMillisSpendTermination();
        ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(60000L);
        return termination;
    }

    public void inherit(TerminationConfig inheritedConfig) {
        if (this.termination == null) {
            this.termination = inheritedConfig.getTermination();
        }
        if (this.terminationClass == null) {
            this.terminationClass = inheritedConfig.getTerminationClass();
        }
        if (this.terminationCompositionStyle == null) {
            this.terminationCompositionStyle = inheritedConfig.getTerminationCompositionStyle();
        }
        if (this.maximumStepCount == null) {
            this.maximumStepCount = inheritedConfig.getMaximumStepCount();
        }
        if (this.maximumTimeMillisSpend == null) {
            this.maximumTimeMillisSpend = inheritedConfig.getMaximumTimeMillisSpend();
        }
        if (this.maximumSecondsSpend == null) {
            this.maximumSecondsSpend = inheritedConfig.getMaximumSecondsSpend();
        }
        if (this.maximumMinutesSpend == null) {
            this.maximumMinutesSpend = inheritedConfig.getMaximumMinutesSpend();
        }
        if (this.maximumHoursSpend == null) {
            this.maximumHoursSpend = inheritedConfig.getMaximumHoursSpend();
        }
        if (this.scoreAttained == null) {
            this.scoreAttained = inheritedConfig.getScoreAttained();
        }
        if (this.maximumUnimprovedStepCount == null) {
            this.maximumUnimprovedStepCount = inheritedConfig.getMaximumUnimprovedStepCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TerminationCompositionStyle {
        AND,
        OR;

    }
}

