/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import org.drools.RuleBase;
import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.bruteforce.BruteForceSolutionIterator;
import org.drools.planner.core.bruteforce.BruteForceSolver;
import org.drools.planner.core.bruteforce.BruteForceSolverScope;
import org.drools.planner.core.bruteforce.BruteForceStepScope;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.AbstractSolver;
import org.drools.planner.core.solver.AbstractSolverScope;

public class DefaultBruteForceSolver
extends AbstractSolver
implements BruteForceSolver {
    protected BruteForceSolverScope bruteForceSolverScope = new BruteForceSolverScope();

    public void setRuleBase(RuleBase ruleBase) {
        this.bruteForceSolverScope.setRuleBase(ruleBase);
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.bruteForceSolverScope.setScoreDefinition(scoreDefinition);
    }

    public ScoreDefinition getScoreDefinition() {
        return this.bruteForceSolverScope.getScoreDefinition();
    }

    public void setScoreCalculator(ScoreCalculator scoreCalculator) {
        this.bruteForceSolverScope.setWorkingScoreCalculator(scoreCalculator);
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public void setStartingSolution(Solution startingSolution) {
        this.bruteForceSolverScope.setWorkingSolution(startingSolution);
    }

    public Solution getBestSolution() {
        return this.bruteForceSolverScope.getBestSolution();
    }

    public long getTimeMillisSpend() {
        return this.bruteForceSolverScope.calculateTimeMillisSpend();
    }

    public AbstractSolverScope getAbstractSolverScope() {
        return this.bruteForceSolverScope;
    }

    protected void solveImplementation() {
        BruteForceSolverScope bruteForceSolverScope = this.bruteForceSolverScope;
        this.solvingStarted(bruteForceSolverScope);
        BruteForceSolutionIterator bruteForceSolutionIterator = new BruteForceSolutionIterator(bruteForceSolverScope);
        BruteForceStepScope bruteForceStepScope = this.createNextStepScope(bruteForceSolverScope, null);
        while (bruteForceSolutionIterator.hasNext()) {
            Score score = bruteForceSolverScope.calculateScoreFromWorkingMemory();
            bruteForceStepScope.setScore(score);
            this.bestSolutionRecaller.stepTaken(bruteForceStepScope);
            this.logger.debug("Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{bruteForceStepScope.getStepIndex(), bruteForceSolverScope.calculateTimeMillisSpend(), bruteForceStepScope.getScore(), bruteForceStepScope.getBestScoreImproved() != false ? "new" : "   ", bruteForceSolverScope.getBestScore()});
            bruteForceStepScope = this.createNextStepScope(bruteForceSolverScope, bruteForceStepScope);
            bruteForceSolutionIterator.next();
        }
        this.solvingEnded(bruteForceSolverScope);
    }

    private BruteForceStepScope createNextStepScope(BruteForceSolverScope bruteForceSolverScope, BruteForceStepScope completedBruteForceStepScope) {
        if (completedBruteForceStepScope == null) {
            completedBruteForceStepScope = new BruteForceStepScope(bruteForceSolverScope);
            completedBruteForceStepScope.setScore(bruteForceSolverScope.getStartingScore());
            completedBruteForceStepScope.setStepIndex(-1);
        }
        BruteForceStepScope bruteForceStepScope = new BruteForceStepScope(bruteForceSolverScope);
        bruteForceStepScope.setStepIndex(completedBruteForceStepScope.getStepIndex() + 1);
        return bruteForceStepScope;
    }

    private LocalSearchStepScope createNextStepScope(LocalSearchSolverScope localSearchSolverScope, LocalSearchStepScope completedLocalSearchStepScope) {
        if (completedLocalSearchStepScope == null) {
            completedLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
            completedLocalSearchStepScope.setScore(localSearchSolverScope.getStartingScore());
            completedLocalSearchStepScope.setStepIndex(-1);
            completedLocalSearchStepScope.setTimeGradient(0.0);
        }
        localSearchSolverScope.setLastCompletedLocalSearchStepScope(completedLocalSearchStepScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
        localSearchStepScope.setStepIndex(completedLocalSearchStepScope.getStepIndex() + 1);
        return localSearchStepScope;
    }

    public void solvingStarted(BruteForceSolverScope bruteForceSolverScope) {
        super.solvingStarted(bruteForceSolverScope);
    }

    public void solvingEnded(BruteForceSolverScope bruteForceSolverScope) {
        this.bestSolutionRecaller.solvingEnded(bruteForceSolverScope);
        long timeMillisSpend = bruteForceSolverScope.calculateTimeMillisSpend();
        long averageCalculateCountPerSecond = bruteForceSolverScope.getCalculateCount() * 1000L / timeMillisSpend;
        this.logger.info("Solved with time spend ({}) for best score ({}) with average calculate count per second ({}).", new Object[]{timeMillisSpend, bruteForceSolverScope.getBestScore(), averageCalculateCountPerSecond});
    }
}

