/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider;

import java.util.Iterator;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolver localSearchSolver;
    protected DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected Selector selector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setLocalSearchSolver(LocalSearchSolver localSearchSolver) {
        this.localSearchSolver = localSearchSolver;
    }

    public DeciderScoreComparatorFactory getDeciderScoreComparator() {
        return this.deciderScoreComparatorFactory;
    }

    public void setDeciderScoreComparator(DeciderScoreComparatorFactory deciderScoreComparator) {
        this.deciderScoreComparatorFactory = deciderScoreComparator;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
        selector.setDecider(this);
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        this.deciderScoreComparatorFactory.solvingStarted(localSearchSolverScope);
        this.selector.solvingStarted(localSearchSolverScope);
        this.acceptor.solvingStarted(localSearchSolverScope);
        this.forager.solvingStarted(localSearchSolverScope);
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.beforeDeciding(localSearchStepScope);
        localSearchStepScope.setDeciderScoreComparator(this.deciderScoreComparatorFactory.createDeciderScoreComparator());
        this.selector.beforeDeciding(localSearchStepScope);
        this.acceptor.beforeDeciding(localSearchStepScope);
        this.forager.beforeDeciding(localSearchStepScope);
    }

    public void decideNextStep(LocalSearchStepScope localSearchStepScope) {
        MoveScope pickedMoveScope;
        WorkingMemory workingMemory = localSearchStepScope.getWorkingMemory();
        Iterator<Move> moveIterator = this.selector.moveIterator(localSearchStepScope);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            MoveScope moveScope = new MoveScope(localSearchStepScope);
            moveScope.setMove(move);
            if (move.isMoveDoable(workingMemory)) {
                this.doMove(moveScope);
                if (!this.forager.isQuitEarly()) continue;
                break;
            }
            this.logger.debug("    Ignoring not doable move ({}).", (Object)move);
        }
        if ((pickedMoveScope = this.forager.pickMove(localSearchStepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            localSearchStepScope.setStep(step);
            localSearchStepScope.setUndoStep(step.createUndoMove(workingMemory));
            localSearchStepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(MoveScope moveScope) {
        Score lastCompletedStepScore;
        Score undoScore;
        WorkingMemory workingMemory = moveScope.getWorkingMemory();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(workingMemory);
        moveScope.setUndoMove(undoMove);
        move.doMove(workingMemory);
        this.processMove(moveScope);
        undoMove.doMove(workingMemory);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().calculateScoreFromWorkingMemory()).equals(lastCompletedStepScore = moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().getLastCompletedLocalSearchStepScope().getScore())) {
            throw new IllegalStateException("Corrupted undo move (" + undoMove + ") received from move (" + move + ").\n" + "Unequal lastCompletedStepScore (" + lastCompletedStepScore + ") and undoScore (" + undoScore + ").\n" + moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().buildConstraintOccurrenceSummary());
        }
        this.logger.debug("    Move score ({}), accept chance ({}) for move ({}).", new Object[]{moveScope.getScore(), moveScope.getAcceptChance(), moveScope.getMove()});
    }

    private void processMove(MoveScope moveScope) {
        Score score = moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().calculateScoreFromWorkingMemory();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().assertWorkingScore(score);
        }
        moveScope.setScore(score);
        double acceptChance = this.acceptor.calculateAcceptChance(moveScope);
        moveScope.setAcceptChance(acceptChance);
        this.forager.addMove(moveScope);
    }

    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepDecided(localSearchStepScope);
        this.selector.stepDecided(localSearchStepScope);
        this.acceptor.stepDecided(localSearchStepScope);
        this.forager.stepDecided(localSearchStepScope);
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepTaken(localSearchStepScope);
        this.selector.stepTaken(localSearchStepScope);
        this.acceptor.stepTaken(localSearchStepScope);
        this.forager.stepTaken(localSearchStepScope);
    }

    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        this.deciderScoreComparatorFactory.solvingEnded(localSearchSolverScope);
        this.selector.solvingEnded(localSearchSolverScope);
        this.acceptor.solvingEnded(localSearchSolverScope);
        this.forager.solvingEnded(localSearchSolverScope);
    }
}

