/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.termination;

import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private int maximumUnimprovedStepCount = 100;

    public void setMaximumUnimprovedStepCount(int maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
        if (maximumUnimprovedStepCount < 0) {
            throw new IllegalArgumentException("Property maximumUnimprovedStepCount (" + maximumUnimprovedStepCount + ") must be greater or equal to 0.");
        }
    }

    private int calculateUnimprovedStepCount(LocalSearchStepScope localSearchStepScope) {
        int bestStepIndex = localSearchStepScope.getLocalSearchSolverScope().getBestSolutionStepIndex();
        int stepIndex = localSearchStepScope.getStepIndex();
        return stepIndex - bestStepIndex;
    }

    public boolean isTerminated(LocalSearchStepScope localSearchStepScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(localSearchStepScope);
        return unimprovedStepCount >= this.maximumUnimprovedStepCount;
    }

    public double calculateTimeGradient(LocalSearchStepScope localSearchStepScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(localSearchStepScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.maximumUnimprovedStepCount;
        return Math.min(timeGradient, 1.0);
    }
}

