/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import org.drools.ancompiler.SwitchCompilerHandler;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.util.index.AlphaRangeIndex;

public class ModifyHandler
extends SwitchCompilerHandler {
    private static final String ASSERT_METHOD_SIGNATURE = "public final void propagateModifyObject(" + FACT_HANDLE_PARAM_TYPE + " " + "handle" + "," + MODIFY_PREVIOUS_TUPLE_NAME + " " + "modifyPreviousTuples" + "," + PROP_CONTEXT_PARAM_TYPE + " " + "context" + "," + WORKING_MEMORY_PARAM_TYPE + " " + "wm" + "){";
    private final boolean alphaNetContainsHashedField;
    private final String factClassName;

    ModifyHandler(StringBuilder builder, String factClassName) {
        this(builder, factClassName, false);
    }

    public ModifyHandler(StringBuilder builder, String factClassName, boolean alphaNetContainsHashedField) {
        super(builder);
        this.factClassName = factClassName;
        this.alphaNetContainsHashedField = alphaNetContainsHashedField;
    }

    @Override
    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append(ASSERT_METHOD_SIGNATURE).append("\n");
        if (this.alphaNetContainsHashedField) {
            this.builder.append(this.factClassName).append(" ").append("fact").append(" = (").append(this.factClassName).append(")").append("handle").append(".getObject();").append("\n");
        }
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(this.getVariableName((Sink)betaNode)).append(".modifyObject(").append("handle").append(",").append("modifyPreviousTuples").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startWindowNode(WindowNode windowNode) {
        this.builder.append(this.getVariableName((Sink)windowNode)).append(".modifyObject(").append("handle").append(",").append("modifyPreviousTuples").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(this.getVariableName((Sink)leftInputAdapterNode)).append(".modifyObject(").append("handle").append(",").append("modifyPreviousTuples").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("if ( ").append(this.getVariableName(alphaNode)).append(".isAllowed(").append("handle").append(",").append("wm").append(") ) {").append("\n");
    }

    @Override
    public void endNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("}").append("\n");
    }

    @Override
    public void startHashedAlphaNodes(IndexableConstraint indexableConstraint) {
        this.generateSwitch(indexableConstraint);
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.generateSwitchCase(hashedAlpha, hashedValue);
    }

    @Override
    public void endHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.builder.append("break;").append("\n");
    }

    @Override
    public void endHashedAlphaNodes(IndexableConstraint hashedFieldReader) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }

    @Override
    public void endObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append("}").append("\n");
    }

    @Override
    public void startRangeIndex(AlphaRangeIndex alphaRangeIndex) {
        String rangeIndexVariableName = this.getRangeIndexVariableName(alphaRangeIndex, this.getMinIdFromRangeIndex(alphaRangeIndex));
        String matchingResultVariableName = rangeIndexVariableName + "_result";
        String matchingNodeVariableName = matchingResultVariableName + "_node";
        this.builder.append("java.util.Collection<org.drools.core.reteoo.AlphaNode> " + matchingResultVariableName + " = " + rangeIndexVariableName + ".getMatchingAlphaNodes(" + "handle" + ".getObject());").append("\n");
        this.builder.append("for (org.drools.core.reteoo.AlphaNode " + matchingNodeVariableName + " : " + matchingResultVariableName + ") {").append("\n");
        this.builder.append("switch (" + matchingNodeVariableName + ".getId()) {").append("\n");
    }

    @Override
    public void startRangeIndexedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("case " + alphaNode.getId() + ":").append("\n");
    }

    @Override
    public void endRangeIndexedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("break;").append("\n");
    }

    @Override
    public void endRangeIndex(AlphaRangeIndex alphaRangeIndex) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }
}

