/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import org.drools.ancompiler.AbstractCompilerHandler;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.WindowNode;

public class SetNodeReferenceHandler
extends AbstractCompilerHandler {
    private static final String PARAM_TYPE = NetworkNode.class.getName();
    private static final String PARAM_NAME = "node";
    private static final String SET_NETWORK_NODE_REFERENCE_SIGNATURE = "protected void setNetworkNodeReference(" + PARAM_TYPE + " " + "node" + "){";
    private final StringBuilder builder;
    private static final String CASE = "case ";
    private static final String BREAK = "break;";

    public SetNodeReferenceHandler(StringBuilder builder) {
        this.builder = builder;
    }

    private String getVariableAssignmentStatement(Sink sink, String nodeVariableName) {
        Class<?> variableType = this.getVariableType(sink);
        String assignmentStatement = this.getVariableName(sink) + " = (" + variableType.getName() + ")" + nodeVariableName + ";";
        return assignmentStatement;
    }

    private String getVariableAssignmentStatement(AlphaNode alphaNode, String nodeVariableName) {
        Class<?> variableType = this.getVariableType(alphaNode);
        String assignmentStatement = this.getVariableName(alphaNode) + " = (" + variableType.getName() + ") ((" + AlphaNode.class.getName() + ")" + nodeVariableName + ").getConstraint();";
        return assignmentStatement;
    }

    @Override
    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append(SET_NETWORK_NODE_REFERENCE_SIGNATURE).append("\n");
        this.builder.append("switch (").append(PARAM_NAME).append(".getId()) {").append("\n");
    }

    @Override
    public void endObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append(CASE).append(alphaNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement(alphaNode, PARAM_NAME)).append("\n");
        this.builder.append(BREAK).append("\n");
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(CASE).append(betaNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement((Sink)betaNode, PARAM_NAME)).append("\n");
        this.builder.append(BREAK).append("\n");
    }

    @Override
    public void startWindowNode(WindowNode windowNode) {
        this.builder.append(CASE).append(windowNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement((Sink)windowNode, PARAM_NAME)).append("\n");
        this.builder.append(BREAK).append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(CASE).append(leftInputAdapterNode.getId()).append(": ").append("\n");
        this.builder.append(this.getVariableAssignmentStatement((Sink)leftInputAdapterNode, PARAM_NAME)).append("\n");
        this.builder.append(BREAK).append("\n");
    }
}

