/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.ancompiler.NetworkHandler;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.util.index.AlphaRangeIndex;

public class ObjectTypeNodeParser {
    private final ObjectTypeNode objectTypeNode;
    private LinkedHashSet<IndexableConstraint> indexableConstraints = new LinkedHashSet();
    private boolean traverseHashedAlphaNodes = true;

    public void setTraverseHashedAlphaNodes(boolean traverseHashedAlphaNodes) {
        this.traverseHashedAlphaNodes = traverseHashedAlphaNodes;
    }

    public ObjectTypeNodeParser(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
    }

    public void accept(NetworkHandler handler) {
        ObjectSinkPropagator propagator = this.objectTypeNode.getObjectSinkPropagator();
        handler.startObjectTypeNode(this.objectTypeNode);
        this.traversePropagator(propagator, handler);
        handler.endObjectTypeNode(this.objectTypeNode);
    }

    private void traversePropagator(ObjectSinkPropagator propagator, NetworkHandler handler) {
        if (propagator instanceof SingleObjectSinkAdapter) {
            ObjectSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter composite = (CompositeObjectSinkAdapter)propagator;
            if (this.traverseHashedAlphaNodes) {
                this.traverseSinkList(composite.getRangeIndexableSinks(), handler);
                this.traverseSinkList(composite.getHashableSinks(), handler);
                this.traverseSinkList(composite.getOthers(), handler);
                this.traverseRangeIndexedAlphaNodes(composite.getRangeIndexMap(), handler);
                this.traverseHashedAlphaNodes(composite.getHashedSinkMap(), handler);
            } else {
                this.traverseSinkList(composite.getSinks(), handler);
            }
        } else if (propagator instanceof CompositePartitionAwareObjectSinkAdapter) {
            CompositePartitionAwareObjectSinkAdapter composite = (CompositePartitionAwareObjectSinkAdapter)propagator;
            this.traverseSinkList(composite.getSinks(), handler);
        }
    }

    private void traverseSinkList(List<? extends ObjectSinkNode> sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (ObjectSinkNode objectSinkNode : sinks) {
                this.traverseSink((ObjectSink)objectSinkNode, handler);
            }
        }
    }

    private void traverseSinkList(ObjectSink[] sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (ObjectSink sink : sinks) {
                this.traverseSink(sink, handler);
            }
        }
    }

    private void traverseHashedAlphaNodes(Map<CompositeObjectSinkAdapter.HashKey, AlphaNode> hashedAlphaNodes, NetworkHandler handler) {
        if (hashedAlphaNodes != null && !hashedAlphaNodes.isEmpty()) {
            AlphaNode firstAlpha = hashedAlphaNodes.values().iterator().next();
            IndexableConstraint hashedFieldReader = this.getClassFieldReaderForHashedAlpha(firstAlpha);
            this.indexableConstraints.add(hashedFieldReader);
            handler.startHashedAlphaNodes(hashedFieldReader);
            AlphaNode optionalNullAlphaNodeCase = null;
            for (Map.Entry<CompositeObjectSinkAdapter.HashKey, AlphaNode> entry : hashedAlphaNodes.entrySet()) {
                CompositeObjectSinkAdapter.HashKey hashKey = entry.getKey();
                AlphaNode alphaNode = entry.getValue();
                Object objectValue = hashKey.getObjectValue();
                if (objectValue != null) {
                    handler.startHashedAlphaNode(alphaNode, objectValue);
                    this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
                    handler.endHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                    continue;
                }
                optionalNullAlphaNodeCase = alphaNode;
            }
            handler.endHashedAlphaNodes(hashedFieldReader);
            if (optionalNullAlphaNodeCase != null) {
                handler.nullCaseAlphaNodeStart(optionalNullAlphaNodeCase);
                this.traversePropagator(optionalNullAlphaNodeCase.getObjectSinkPropagator(), handler);
                handler.nullCaseAlphaNodeEnd(optionalNullAlphaNodeCase);
            }
        }
    }

    private void traverseRangeIndexedAlphaNodes(Map<CompositeObjectSinkAdapter.FieldIndex, AlphaRangeIndex> rangeIndexMap, NetworkHandler handler) {
        if (rangeIndexMap == null) {
            return;
        }
        Set<Map.Entry<CompositeObjectSinkAdapter.FieldIndex, AlphaRangeIndex>> entrySet = rangeIndexMap.entrySet();
        for (Map.Entry entry : entrySet) {
            AlphaRangeIndex alphaRangeIndex = (AlphaRangeIndex)entry.getValue();
            handler.startRangeIndex(alphaRangeIndex);
            Collection alphaNodes = alphaRangeIndex.getAllValues();
            for (AlphaNode alphaNode : alphaNodes) {
                handler.startRangeIndexedAlphaNode(alphaNode);
                this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
                handler.endRangeIndexedAlphaNode(alphaNode);
            }
            handler.endRangeIndex(alphaRangeIndex);
        }
    }

    private void traverseSink(ObjectSink sink, NetworkHandler handler) {
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            handler.startNonHashedAlphaNode(alphaNode);
            this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
            handler.endNonHashedAlphaNode(alphaNode);
        } else if (NodeTypeEnums.isBetaNode((NetworkNode)sink)) {
            BetaNode betaNode = (BetaNode)sink;
            handler.startBetaNode(betaNode);
            handler.endBetaNode(betaNode);
        } else if (sink.getType() == 120) {
            LeftInputAdapterNode leftInputAdapterNode = (LeftInputAdapterNode)sink;
            handler.startLeftInputAdapterNode(leftInputAdapterNode);
            handler.endWindowNode(leftInputAdapterNode);
        } else if (sink.getType() == 60) {
            WindowNode windowNode = (WindowNode)sink;
            handler.startWindowNode(windowNode);
            handler.endWindowNode(windowNode);
        }
    }

    private IndexableConstraint getClassFieldReaderForHashedAlpha(AlphaNode alphaNode) {
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (!(fieldConstraint instanceof IndexableConstraint)) {
            throw new IllegalArgumentException("Only support IndexableConstraint hashed AlphaNodes, not " + fieldConstraint.getClass());
        }
        return (IndexableConstraint)fieldConstraint;
    }

    public Set<IndexableConstraint> getIndexableConstraints() {
        return this.indexableConstraints;
    }

    public IndexableConstraint getIndexableConstraint() {
        IndexableConstraint[] constraintsArray = this.indexableConstraints.toArray(new IndexableConstraint[0]);
        return this.indexableConstraints.isEmpty() ? null : constraintsArray[constraintsArray.length - 1];
    }
}

