/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.util.ArrayList;
import java.util.List;
import org.drools.benchmark.Benchmark;
import org.drools.benchmark.BenchmarkConfig;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.BenchmarkResult;
import org.drools.benchmark.ResultsAccumulator;
import org.drools.benchmark.util.MemoryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkRunner {
    private static final String CONFIG_FILE = "benchmark.xml";

    public static void main(String[] args) {
        new BenchmarkRunner().run();
    }

    private void run() {
        long start = System.currentTimeMillis();
        BenchmarkConfig config = new BenchmarkConfig(CONFIG_FILE);
        ArrayList<List<BenchmarkResult>> results = new ArrayList<List<BenchmarkResult>>();
        for (int i = 0; i < config.getRepetitions(); ++i) {
            results.add(this.executeAll(config, i));
        }
        this.printResults(this.accumulateResults(results));
        System.out.println("\nDone in " + (System.currentTimeMillis() - start) + " msecs");
    }

    private void printResults(List<ResultsAccumulator> results) {
        System.out.println("Benchmark Description;Min Duration;Max Duration;Avg Duration;Min Used Memory;Max Used Memory;Avg Used Memory");
        for (ResultsAccumulator result : results) {
            System.out.println(result);
        }
    }

    private List<ResultsAccumulator> accumulateResults(List<List<BenchmarkResult>> results) {
        int benchmarksNr = results.get(0).size();
        ArrayList<ResultsAccumulator> accumulatedResults = new ArrayList<ResultsAccumulator>();
        for (int i = 0; i < benchmarksNr; ++i) {
            ResultsAccumulator accumulator = new ResultsAccumulator();
            for (List<BenchmarkResult> runResults : results) {
                accumulator.accumulate(runResults.get(i));
            }
            accumulatedResults.add(accumulator);
        }
        return accumulatedResults;
    }

    private List<BenchmarkResult> executeAll(BenchmarkConfig config, int execNr) {
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>();
        for (BenchmarkDefinition benchmarkDef : config) {
            if (!benchmarkDef.isEnabled()) continue;
            BenchmarkResult result = this.execute(config, benchmarkDef, execNr == 0);
            System.out.println(result);
            results.add(result);
        }
        MemoryUtil.aggressiveGC(config.getDelay());
        return results;
    }

    private BenchmarkResult execute(BenchmarkConfig config, BenchmarkDefinition definition, boolean shouldWarmUp) {
        BenchmarkResult result = new BenchmarkResult(definition);
        if (shouldWarmUp) {
            this.warmUpExecution(config, definition);
        }
        MemoryUtil.aggressiveGC(config.getDelay());
        result.setUsedMemoryBeforeStart(MemoryUtil.usedMemory());
        Benchmark benchmark = definition.instance();
        System.out.println("Executing: " + definition.getDescription());
        benchmark.init(definition);
        result.setDuration(this.executeBenchmark(definition, benchmark));
        benchmark.terminate();
        MemoryUtil.aggressiveGC(config.getDelay());
        result.setUsedMemoryAfterEnd(MemoryUtil.usedMemory());
        benchmark = null;
        MemoryUtil.aggressiveGC(config.getDelay());
        result.setUsedMemoryAfterGC(MemoryUtil.usedMemory());
        return result;
    }

    private void warmUpExecution(BenchmarkConfig config, BenchmarkDefinition definition) {
        if (definition.getWarmups() < 1) {
            return;
        }
        System.out.println("Warming up: " + definition.getDescription());
        Benchmark benchmark = definition.instance();
        benchmark.init(definition);
        for (int i = 0; i < definition.getWarmups(); ++i) {
            benchmark.execute(0);
        }
        benchmark.terminate();
        MemoryUtil.aggressiveGC(config.getDelay());
    }

    private double executeBenchmark(BenchmarkDefinition definition, Benchmark benchmark) {
        long start = System.nanoTime();
        for (int i = 0; i < definition.getRepetitions(); ++i) {
            benchmark.execute(i);
        }
        return (double)((System.nanoTime() - start) / 1000L) / 1000.0;
    }
}

