/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuleIntegrationException;
import org.drools.StatefulSession;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.waltz.Line;
import org.drools.benchmark.model.waltz.Stage;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;

public class WaltzBenchmark
extends AbstractBenchmark {
    private RuleBase ruleBase;
    private List<Line> lines = new ArrayList<Line>();

    public void init(BenchmarkDefinition definition) {
        try {
            this.ruleBase = this.readRule();
            this.loadLines("/waltz50.dat");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(int repNr) {
        StatefulSession session = this.ruleBase.newStatefulSession();
        for (Line l : this.lines) {
            session.insert((Object)l);
        }
        session.insert((Object)new Stage(1));
        session.fireAllRules();
        session.dispose();
    }

    private RuleBase readRule() throws Exception, DroolsParserException, RuleIntegrationException, PackageIntegrationException, InvalidPatternException {
        InputStreamReader reader = new InputStreamReader(WaltzBenchmark.class.getResourceAsStream("/waltz.drl"));
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse((Reader)reader);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)1);
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    private void loadLines(String filename) throws IOException {
        if (!this.lines.isEmpty()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzBenchmark.class.getResourceAsStream(filename)));
        Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
        String line = reader.readLine();
        while (line != null) {
            Matcher m = pat.matcher(line);
            if (m.matches()) {
                Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                this.lines.add(l);
            }
            line = reader.readLine();
        }
        reader.close();
    }
}

