/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.util.HashMap;
import java.util.Map;
import org.drools.model.functions.Predicate2;
import org.drools.model.operators.ContainsOperator;
import org.drools.model.operators.ExcludesOperator;
import org.drools.model.operators.InOperator;
import org.drools.model.operators.MatchesOperator;
import org.drools.model.operators.MemberOfOperator;
import org.drools.model.operators.SoundsLikeOperator;

public interface Operator<A, B>
extends Predicate2<A, B[]> {
    public String getOperatorName();

    public static class Register {
        private static final Map<String, Operator> opMap = new HashMap<String, Operator>();

        public static void register(Operator operator) {
            opMap.put(operator.getOperatorName(), operator);
        }

        public static boolean hasOperator(String opName) {
            return opMap.containsKey(opName);
        }

        public static Operator getOperator(String opName) {
            return opMap.get(opName);
        }

        static {
            Register.register(InOperator.INSTANCE);
            Register.register(MatchesOperator.INSTANCE);
            Register.register(ContainsOperator.INSTANCE);
            Register.register(ExcludesOperator.INSTANCE);
            Register.register(MemberOfOperator.INSTANCE);
            Register.register(SoundsLikeOperator.INSTANCE);
        }
    }

    public static interface MultipleValue<A, B>
    extends Operator<A, B> {
        @Override
        default public boolean test(A o1, B[] o2) {
            return this.eval(o1, o2);
        }

        public boolean eval(A var1, B[] var2);
    }

    public static interface SingleValue<A, B>
    extends Operator<A, B> {
        @Override
        default public boolean test(A o1, B[] o2) {
            return this.eval(o1, o2[0]);
        }

        public boolean eval(A var1, B var2);
    }
}

