/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class CoincidesPredicate
extends AbstractTemporalPredicate {
    private final long startDevLong;
    private final long endDevLong;

    public CoincidesPredicate(long dev, TimeUnit devUnit) {
        super(new Interval(Long.MIN_VALUE, Long.MAX_VALUE));
        this.startDevLong = TimeUtil.unitToLong(dev, devUnit);
        this.endDevLong = TimeUtil.unitToLong(dev, devUnit);
    }

    public String toString() {
        return "coincides" + this.interval;
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = Math.abs(start2 - start1);
        long distEnd = Math.abs(end2 - end1);
        return distStart <= this.startDevLong && distEnd <= this.endDevLong;
    }
}

