/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.drools.model.Binding;
import org.drools.model.Constraint;
import org.drools.model.Pattern;
import org.drools.model.SingleConstraint;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.impl.ModelComponent;
import org.drools.model.patterns.AbstractSinglePattern;

public class PatternImpl<T>
extends AbstractSinglePattern
implements Pattern<T>,
ModelComponent {
    private final Variable<T> variable;
    private Variable[] inputVariables;
    private Variable[] allInputVariables = new Variable[0];
    private Constraint constraint;
    private List<Binding> bindings;
    private Collection<String> watchedProps;

    public PatternImpl(Variable<T> variable) {
        this(variable, SingleConstraint.EMPTY);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint) {
        this(variable, constraint, null);
    }

    public PatternImpl(Variable<T> variable, Constraint constraint, List<Binding> bindings) {
        this.variable = variable;
        this.constraint = constraint;
        this.bindings = bindings;
    }

    @Override
    public Variable<T> getPatternVariable() {
        return this.variable;
    }

    @Override
    public Variable<?>[] getBoundVariables() {
        return new Variable[]{this.variable};
    }

    @Override
    public Variable[] getInputVariables() {
        if (this.inputVariables == null) {
            this.inputVariables = this.collectInputVariables();
        }
        return this.inputVariables;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public void addConstraint(Constraint constraint) {
        this.constraint = ((AbstractConstraint)this.constraint).and(constraint);
    }

    public void addBinding(Binding binding) {
        if (this.bindings == null) {
            this.bindings = new ArrayList<Binding>();
        }
        this.bindings.add(binding);
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindings != null ? this.bindings : Collections.emptyList();
    }

    public void addWatchedProps(String[] props) {
        if (props == null || props.length == 0) {
            return;
        }
        if (this.watchedProps == null) {
            this.watchedProps = new LinkedHashSet<String>();
        }
        for (String prop : props) {
            this.watchedProps.add(prop);
        }
    }

    public void addAllInputVariables(Variable[] variables) {
        this.allInputVariables = variables;
    }

    public Variable[] getAllInputVariables() {
        return this.allInputVariables;
    }

    @Override
    public String[] getWatchedProps() {
        return this.watchedProps != null ? this.watchedProps.toArray(new String[this.watchedProps.size()]) : new String[]{};
    }

    private Variable[] collectInputVariables() {
        HashSet<Variable> varSet = new HashSet<Variable>();
        this.collectInputVariables(this.constraint, varSet);
        return varSet.toArray(new Variable[varSet.size()]);
    }

    private void collectInputVariables(Constraint constraint, Set<Variable> varSet) {
        if (constraint instanceof SingleConstraint) {
            for (Variable var : ((SingleConstraint)constraint).getVariables()) {
                varSet.add(var);
            }
        } else {
            for (Constraint child : constraint.getChildren()) {
                this.collectInputVariables(child, varSet);
            }
        }
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternImpl)) {
            return false;
        }
        PatternImpl pattern = (PatternImpl)o;
        if (!ModelComponent.areEqualInModel(this.variable, pattern.variable)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.inputVariables, pattern.inputVariables)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.constraint, pattern.constraint)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.bindings, pattern.bindings)) {
            return false;
        }
        return this.watchedProps != null ? this.watchedProps.equals(pattern.watchedProps) : pattern.watchedProps == null;
    }
}

