/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class IncludesPredicate
extends AbstractTemporalPredicate<IncludesPredicate> {
    private final long startMinDev;
    private final long startMaxDev;
    private final long endMinDev;
    private final long endMaxDev;

    public IncludesPredicate() {
        this(1L, Long.MAX_VALUE);
    }

    public IncludesPredicate(long max, TimeUnit maxUnit) {
        this(1L, TimeUtil.unitToLong(max, maxUnit));
    }

    public IncludesPredicate(long min, TimeUnit minUnit, long max, TimeUnit maxUnit) {
        this(TimeUtil.unitToLong(min, minUnit), TimeUtil.unitToLong(max, maxUnit));
    }

    private IncludesPredicate(long min, long max) {
        this.startMinDev = min;
        this.startMaxDev = max;
        this.endMinDev = min;
        this.endMaxDev = max;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "includes[" + this.startMinDev + ", " + this.startMaxDev + "]";
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(Long.MIN_VALUE, 0L);
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = start2 - start1;
        long distEnd = end1 - end2;
        return this.negated ^ (distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev);
    }

    @Override
    protected boolean isTemporalPredicateEqualTo(IncludesPredicate other) {
        return this.startMinDev == other.startMinDev && this.startMaxDev == other.startMaxDev && this.endMinDev == other.endMinDev && this.endMaxDev == other.endMaxDev;
    }
}

