/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class PredicateInformation {
    public static final PredicateInformation EMPTY_PREDICATE_INFORMATION = new PredicateInformation("", "", "");
    private final String stringConstraint;
    private final Set<RuleDef> ruleDefs = new TreeSet<RuleDef>();
    public static final int MAX_RULE_DEFS = Integer.getInteger("drools.predicateInformation.maxRuleDefs", 10);
    private boolean moreThanMaxRuleDefs = false;

    public PredicateInformation(String stringConstraint, String ... ruleNames) {
        this.stringConstraint = PredicateInformation.defaultToEmptyString(stringConstraint);
        this.addRuleNames(ruleNames);
    }

    public PredicateInformation(String stringConstraint, String ruleName, String ruleFileName) {
        this(stringConstraint, new String[]{ruleName, ruleFileName});
    }

    public String getStringConstraint() {
        return this.stringConstraint;
    }

    public Set<RuleDef> getRuleDefs() {
        return this.ruleDefs;
    }

    public void addRuleNames(String ... ruleNames) {
        for (int i = 0; i < ruleNames.length; i += 2) {
            if (this.ruleDefs.size() >= MAX_RULE_DEFS) {
                this.moreThanMaxRuleDefs = true;
                break;
            }
            this.ruleDefs.add(new RuleDef(PredicateInformation.defaultToEmptyString(ruleNames[i + 1]), PredicateInformation.defaultToEmptyString(ruleNames[i])));
        }
    }

    public boolean isMoreThanMaxRuleDefs() {
        return this.moreThanMaxRuleDefs;
    }

    public void setMoreThanMaxRuleDefs(boolean moreThanMaxRuleDefs) {
        this.moreThanMaxRuleDefs = moreThanMaxRuleDefs;
    }

    public Map<String, Set<String>> getRuleNameMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (RuleDef ruleDef : this.ruleDefs) {
            map.computeIfAbsent(ruleDef.fileName, k -> new HashSet()).add(ruleDef.ruleName);
        }
        return map;
    }

    public static String defaultToEmptyString(String str) {
        return str == null ? "" : str;
    }

    public boolean isEmpty() {
        return EMPTY_PREDICATE_INFORMATION.equals(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PredicateInformation other = (PredicateInformation)obj;
        return this.moreThanMaxRuleDefs == other.moreThanMaxRuleDefs && Objects.equals(this.ruleDefs, other.ruleDefs) && Objects.equals(this.stringConstraint, other.stringConstraint);
    }

    public int hashCode() {
        return Objects.hash(this.moreThanMaxRuleDefs, this.ruleDefs, this.stringConstraint);
    }

    public String toString() {
        return "PredicateInformation [stringConstraint=" + this.stringConstraint + ", ruleDefs=" + this.ruleDefs + ", moreThanMaxRuleDefs=" + this.moreThanMaxRuleDefs + "]";
    }

    public static class RuleDef
    implements Comparable<RuleDef> {
        private final String fileName;
        private final String ruleName;

        public RuleDef(String fileName, String ruleName) {
            this.fileName = fileName;
            this.ruleName = ruleName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        @Override
        public int compareTo(RuleDef other) {
            int fileNameCompare = this.fileName.compareTo(other.fileName);
            return fileNameCompare != 0 ? fileNameCompare : this.ruleName.compareTo(other.ruleName);
        }

        public String toString() {
            return "RuleDef{fileName='" + this.fileName + '\'' + ", ruleName='" + this.ruleName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleDef ruleDef = (RuleDef)o;
            return Objects.equals(this.fileName, ruleDef.fileName) && Objects.equals(this.ruleName, ruleDef.ruleName);
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.ruleName);
        }
    }
}

