/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeFact;
import org.drools.model.PrototypeFactFactory;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function3;

public interface PrototypeExpression {
    public Function1<PrototypeFact, Object> asFunction(Prototype var1);

    public Collection<String> getImpactedFields();

    public static PrototypeExpression fixedValue(Object value) {
        return new FixedValue(value);
    }

    public static PrototypeExpression thisPrototype() {
        return ThisPrototype.INSTANCE;
    }

    public static PrototypeExpression prototypeField(String fieldName) {
        return new PrototypeFieldValue(fieldName);
    }

    public static PrototypeExpression prototypeArrayItem(String fieldName, int pos) {
        return new PrototypeArrayItemValue(fieldName, pos);
    }

    default public PrototypeExpression andThen(PrototypeExpression other) {
        return new PrototypeCompositeExpression(this, other);
    }

    default public PrototypeExpression composeWith(BinaryOperation.Operator op, PrototypeExpression right) {
        return new BinaryOperation(this, op, right);
    }

    default public PrototypeExpression add(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.ADD, right);
    }

    default public PrototypeExpression sub(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.SUB, right);
    }

    default public PrototypeExpression mul(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.MUL, right);
    }

    default public PrototypeExpression div(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.DIV, right);
    }

    public static class BinaryOperation
    implements PrototypeExpression {
        private final PrototypeExpression left;
        private final Operator op;
        private final PrototypeExpression right;

        private BinaryOperation(PrototypeExpression left, Operator op, PrototypeExpression right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return this.op.operator.apply(prototype, this.left, this.right);
        }

        public String toString() {
            return this.left + " " + this.op + " " + this.right;
        }

        @Override
        public Collection<String> getImpactedFields() {
            HashSet<String> fields = new HashSet<String>();
            fields.addAll(this.left.getImpactedFields());
            fields.addAll(this.right.getImpactedFields());
            return fields;
        }

        public static enum Operator {
            ADD("+", "add", Operator::add),
            SUB("-", "sub", Operator::sub),
            MUL("*", "mul", Operator::mul),
            DIV("/", "add", Operator::div);

            private final String symbol;
            private final String keyword;
            private final Function3<Prototype, PrototypeExpression, PrototypeExpression, Function1<PrototypeFact, Object>> operator;

            private Operator(String symbol, String keyword, Function3<Prototype, PrototypeExpression, PrototypeExpression, Function1<PrototypeFact, Object>> operator) {
                this.symbol = symbol;
                this.keyword = keyword;
                this.operator = operator;
            }

            private static Function1<PrototypeFact, Object> add(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof String) {
                        return (String)leftValue + (rightValue != null ? rightValue : "");
                    }
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue + (Integer)rightValue;
                    }
                    if (leftValue == null || leftValue == Prototype.UNDEFINED_VALUE) {
                        return rightValue == null ? Integer.valueOf(0) : rightValue;
                    }
                    if (rightValue == null || rightValue == Prototype.UNDEFINED_VALUE) {
                        return leftValue;
                    }
                    return ((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> sub(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue - (Integer)rightValue;
                    }
                    if (leftValue == null || leftValue == Prototype.UNDEFINED_VALUE) {
                        return rightValue == null ? Integer.valueOf(0) : rightValue;
                    }
                    if (rightValue == null || rightValue == Prototype.UNDEFINED_VALUE) {
                        return leftValue;
                    }
                    return ((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> mul(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue * (Integer)rightValue;
                    }
                    if (leftValue == null || leftValue == Prototype.UNDEFINED_VALUE || rightValue == null || rightValue == Prototype.UNDEFINED_VALUE) {
                        return 0;
                    }
                    return ((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> div(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue / (Integer)rightValue;
                    }
                    if (leftValue == null || leftValue == Prototype.UNDEFINED_VALUE || rightValue == null || rightValue == Prototype.UNDEFINED_VALUE) {
                        return 0;
                    }
                    return ((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue();
                };
            }

            public String toString() {
                return this.symbol;
            }

            public String getSymbol() {
                return this.symbol;
            }

            public String getKeyword() {
                return this.keyword;
            }

            public static Operator decodeSymbol(String symbol) {
                return Arrays.stream((Operator[])Operator.class.getEnumConstants()).filter(op -> op.getSymbol().equals(symbol)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unrecognized symbol: " + symbol));
            }

            public static Operator decodeKeyword(String keyword) {
                return Arrays.stream((Operator[])Operator.class.getEnumConstants()).filter(op -> op.getKeyword().equals(keyword)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unrecognized keyword: " + keyword));
            }
        }
    }

    public static class PrototypeCompositeExpression
    implements PrototypeExpression {
        private final PrototypeExpression first;
        private final PrototypeExpression second;

        public PrototypeCompositeExpression(PrototypeExpression first, PrototypeExpression second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return this.first.asFunction(prototype).andThen(this::object2PrototypeFact).andThen(this.second.asFunction(prototype));
        }

        private PrototypeFact object2PrototypeFact(Object object) {
            if (object == Prototype.UNDEFINED_VALUE) {
                return PrototypeFactFactory.get().createMapBasedFact(PrototypeDSL.DEFAULT_PROTOTYPE);
            }
            if (object instanceof PrototypeFact) {
                return (PrototypeFact)object;
            }
            if (object instanceof Map) {
                return PrototypeFactFactory.get().createMapBasedFact(PrototypeDSL.DEFAULT_PROTOTYPE, (Map)object);
            }
            throw new UnsupportedOperationException("Cannot convert " + object + " into a Prototype");
        }

        public String toString() {
            return "PrototypeCompisiteExpression{" + this.first + " composed with " + this.second + "}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return this.first.getImpactedFields();
        }
    }

    public static class PrototypeArrayItemValue
    implements PrototypeExpression {
        private final String fieldName;
        private final int pos;

        PrototypeArrayItemValue(String fieldName, int pos) {
            this.fieldName = fieldName;
            this.pos = pos;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return fact -> this.extractArrayItem(prototype.getFieldValueExtractor(this.fieldName).apply((PrototypeFact)fact));
        }

        private Object extractArrayItem(Object value) {
            if (value instanceof int[]) {
                int[] array = (int[])value;
                return array.length > this.pos ? Integer.valueOf(array[this.pos]) : Prototype.UNDEFINED_VALUE;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                return array.length > this.pos ? array[this.pos] : Prototype.UNDEFINED_VALUE;
            }
            if (value instanceof List) {
                List list = (List)value;
                return list.size() > this.pos ? list.get(this.pos) : Prototype.UNDEFINED_VALUE;
            }
            return Prototype.UNDEFINED_VALUE;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "PrototypeArrayItemValue{" + this.fieldName + "[" + this.pos + "]}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.singletonList(this.fieldName);
        }
    }

    public static class PrototypeFieldValue
    implements PrototypeExpression {
        private final String fieldName;

        PrototypeFieldValue(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return prototype.getFieldValueExtractor(this.fieldName)::apply;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "PrototypeFieldValue{" + this.fieldName + "}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.singletonList(this.fieldName);
        }
    }

    public static enum ThisPrototype implements PrototypeExpression
    {
        INSTANCE;


        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return p -> p;
        }

        public String toString() {
            return "ThisPrototypeFieldValue";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.emptyList();
        }
    }

    public static class FixedValue
    implements PrototypeExpression {
        private final Object value;

        FixedValue(Object value) {
            this.value = value;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return x -> this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "FixedValue{" + this.value + "}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.emptyList();
        }
    }
}

