/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.clips;

import java.util.HashMap;
import java.util.Map;
import org.drools.clips.FunctionHandlers;
import org.drools.clips.LispForm;
import org.drools.clips.StringBuilderAppendable;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.clips.ClipsConsequenceBuilder;
import org.drools.rule.builder.dialect.clips.ClipsEvalBuilder;
import org.drools.rule.builder.dialect.clips.ClipsPredicateBuilder;
import org.drools.rule.builder.dialect.clips.ClipsReturnValueBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipsDialect
extends MVELDialect {
    private static final ClipsConsequenceBuilder CONSEQUENCE_BUILDER = new ClipsConsequenceBuilder();
    private static final ClipsEvalBuilder EVAL_BUILDER = new ClipsEvalBuilder();
    private static final ClipsReturnValueBuilder RETURN_VALUE_BUILDER = new ClipsReturnValueBuilder();
    private static final ClipsPredicateBuilder PREDICATE_BUILDER = new ClipsPredicateBuilder();
    private static Map builders;
    public static final String ID = "clips";

    public ClipsDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
        super(builder, pkgRegistry, pkg, ID);
        this.setLanguageLevel(5);
    }

    public static void initBuilder() {
        if (builders != null) {
            return;
        }
        builders = new HashMap();
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(CollectDescr.class, COLLECT_BUILDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(FunctionDescr.class, FUNCTION_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
    }

    public String getId() {
        return ID;
    }

    public Map getBuilders() {
        return builders;
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)builders.get(clazz);
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, Map<String, Class<?>>[] availableIdentifiers, Map<String, Class<?>> localTypes) {
        if (descr instanceof PredicateDescr) {
            StringBuilderAppendable builder = new StringBuilderAppendable();
            PredicateDescr pdescr = (PredicateDescr)descr;
            if (pdescr.getContent() instanceof LispForm) {
                FunctionHandlers.dump((LispForm)pdescr.getContent(), builder, true);
                content = ((Object)builder).toString();
                pdescr.setContent(content);
            }
        } else if (descr instanceof ReturnValueRestrictionDescr) {
            StringBuilderAppendable builder = new StringBuilderAppendable();
            ReturnValueRestrictionDescr rdescr = (ReturnValueRestrictionDescr)descr;
            if (rdescr.getContent() instanceof LispForm) {
                FunctionHandlers.dump((LispForm)rdescr.getContent(), builder, true);
                content = ((Object)builder).toString();
                rdescr.setContent(content);
            }
        }
        return super.analyzeExpression(context, descr, content, null, localTypes);
    }

    static {
        ClipsDialect.initBuilder();
    }
}

